/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.partition;

import crazydev.common.mdx.scanner.CdMdxScanner;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxDelimitedIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxKeywordToken;
import crazydev.common.mdx.scanner.token.CdMdxNumberToken;
import crazydev.common.mdx.scanner.token.CdMdxRegularIdentifierToken;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadTablePartitionsParams;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.partition.UxLoadPartitionsQuery;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxLoadPartitionsQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxLoadPartitionsQueryMeta LoadPartitions = new UxLoadPartitionsQueryMeta();

    public UxLoadPartitionsQueryMeta() {
        super(UxConsoleConstants.QueryName.LoadPartitions);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        List<String> partitionDefs;
        Integer timeoutS = params.getIntegerParameter("timeoutS");
        String schemaName = params.getExistingStringParameter("schemaName");
        String dataSourceName = params.getExistingStringParameter("dataSourceName");
        String tableName = params.getStringParameter("dataTableName");
        List<String> tablePartitions = params.getStringsParameter("partition");
        ArrayList<OlapEngineLoadTablePartitionsParams> partitions = new ArrayList<OlapEngineLoadTablePartitionsParams>();
        if (CdStringUtils.isNotNullAndNotBlank((String)tableName) && tablePartitions != null && !tablePartitions.isEmpty()) {
            partitions.add(new OlapEngineLoadTablePartitionsParams(tableName, false, tablePartitions));
        }
        if ((partitionDefs = params.getStringsParameter("partitions")) != null && !partitionDefs.isEmpty()) {
            for (String partitionDef : partitionDefs) {
                if (!CdStringUtils.isNotNullAndNotBlank((String)partitionDef)) continue;
                UxLoadPartitionsQueryMeta.parseTablePartitions(partitions, partitionDef);
            }
        }
        if (partitions.isEmpty()) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{"dataTableName|partition|partitions"});
        }
        int waitS = params.getIntegerParameter("waitS", -1);
        int cancelS = params.getIntegerParameter("cancelS", -1);
        boolean continueBackupOnError = params.getBooleanParameter("continueBackupOnError");
        return new UxLoadPartitionsQuery(this, params.getRequestId(), timeoutS, schemaName, dataSourceName, partitions, waitS, cancelS, continueBackupOnError);
    }

    private static void parseTablePartitions(List<OlapEngineLoadTablePartitionsParams> tablesPartitions, String partitionDef) throws UxQueryParserException {
        List<String> tokens = UxLoadPartitionsQueryMeta.scanTablePartitions(partitionDef);
        String table = null;
        boolean asRange = false;
        ArrayList<String> partitions = null;
        for (String token : tokens) {
            if (table == null) {
                if (token.equals(":") || token.equals("and")) {
                    throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"table name expected [actual:" + token + "]"});
                }
                table = token;
                asRange = false;
                partitions = new ArrayList<String>();
                continue;
            }
            if (token.equals(":")) {
                if (asRange) {
                    throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"duplicated partition range for table [" + table + "]"});
                }
                asRange = true;
                continue;
            }
            partitions.add(token);
        }
        if (table == null) {
            throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"no table partition"});
        }
        if (partitions.isEmpty()) {
            throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"no partition for table [" + table + "]"});
        }
        if (asRange && partitions.size() != 2) {
            throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"unexpected partition count for table [" + table + "]"});
        }
        OlapEngineLoadTablePartitionsParams existing = UxLoadPartitionsQueryMeta.getTablePartition(tablesPartitions, table);
        if (existing != null) {
            UxLoadPartitionsQueryMeta.mergeTablePartitions(existing, asRange, (List<String>)partitions);
        } else {
            tablesPartitions.add(new OlapEngineLoadTablePartitionsParams(table, asRange, (List)partitions));
        }
    }

    @Nullable
    private static OlapEngineLoadTablePartitionsParams getTablePartition(List<OlapEngineLoadTablePartitionsParams> tablesPartitions, String table) {
        for (OlapEngineLoadTablePartitionsParams tablePartitions : tablesPartitions) {
            if (!tablePartitions.tableName.equals(table)) continue;
            return tablePartitions;
        }
        return null;
    }

    private static void mergeTablePartitions(OlapEngineLoadTablePartitionsParams params, boolean asRange, List<String> partitions) throws UxQueryParserException {
        if (asRange != params.partitionsAsRange) {
            throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"unexpected partition range for table [" + params.tableName + "]"});
        }
        HashSet existingPartitions = new HashSet(params.partitions);
        for (String partition : partitions) {
            if (existingPartitions.contains(partition)) continue;
            params.partitions.add(partition);
        }
        if (asRange && partitions.size() != 2) {
            throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{"unexpected partition count for table [" + params.tableName + "]"});
        }
    }

    private static List<String> scanTablePartitions(String partitionDef) throws UxQueryParserException {
        try {
            ArrayList<String> rawArgs = new ArrayList<String>();
            CdMdxScanner scanner = new CdMdxScanner();
            List tokens = scanner.scan(partitionDef, "?");
            for (CdMdxToken token : tokens) {
                if (token.isInvisible()) continue;
                if (token.getKind() == CdMdxTokenKind.RANGE) {
                    rawArgs.add(token.getLexeme());
                    continue;
                }
                if (token instanceof CdMdxRegularIdentifierToken) {
                    rawArgs.add(((CdMdxRegularIdentifierToken)token).getIdentifier());
                    continue;
                }
                if (token instanceof CdMdxDelimitedIdentifierToken) {
                    rawArgs.add(((CdMdxDelimitedIdentifierToken)token).getIdentifier());
                    continue;
                }
                if (token instanceof CdMdxNumberToken || token instanceof CdMdxKeywordToken) {
                    rawArgs.add(token.getLexeme());
                    continue;
                }
                String error = "illegal argument (pos:" + token.getStartOffset() + ") " + token.getLexeme();
                throw new UxQueryParserException(UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{error});
            }
            return rawArgs;
        }
        catch (CdMdxScannerException ex) {
            throw new UxQueryParserException(ex, UxErrorCode.LOAD_PARTITIONS_ERROR, new Serializable[]{ex.getMessage()});
        }
    }
}

