/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.partition;

import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadPartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadTablePartitionsParams;
import crazydev.iccube.olap.component.command.builtin.OlapLoadPartitionsHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxLoadPartitionsQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String schemaName;
    private final String dataSourceName;
    private final List<OlapEngineLoadTablePartitionsParams> partitions;
    private final int waitS;
    private final int cancelS;
    private final boolean continueBackupOnError;

    protected UxLoadPartitionsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable Integer timeoutS, String schemaName, String dataSourceName, List<OlapEngineLoadTablePartitionsParams> partitions, int waitS, int cancelS, boolean continueBackupOnError) {
        super(meta, requestId, timeoutS);
        this.schemaName = schemaName;
        this.dataSourceName = dataSourceName;
        this.partitions = partitions;
        this.waitS = waitS;
        this.cancelS = cancelS;
        this.continueBackupOnError = continueBackupOnError;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.LOAD;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isLoadPartitions() {
        return true;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSchemaLifeCycleName() {
        return this.schemaName;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineLoadPartitionsParams params = new OlapEngineLoadPartitionsParams(null, this.schemaName, this.dataSourceName, this.partitions, this.waitS, this.cancelS, this.continueBackupOnError);
        OlapEngineRequestContext eContext = queryContext.getOlapEngineRequestContext();
        OlapLoadPartitionsHelper helper = new OlapLoadPartitionsHelper(eContext);
        OlapSchemaLifeCycleStatus status = helper.loadPartitions(params);
        return UxReply.actionSuccess(new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus()));
    }
}

