/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.offline;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOffline;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflineInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxOfflinesQuery
extends UxAbstractSchemaQuery {
    protected UxOfflinesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        Map snapshots;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "group", "schema", "timestamp", "name");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<UxOffline>("group", babylon.translate("filterSchemaGroup", new Serializable[0]), UxOffline::getSchemaGroup), new UxFilterMeta<UxOffline>("schema", babylon.translate("filterSchemaName", new Serializable[0]), UxOffline::getSchemaName), new UxFilterMeta<UxOffline>("name", babylon.translate("filterSnapshotName", new Serializable[0]), UxOffline::getName));
        UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<UxOffline>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(UxOffline row, String searchText) {
                return this.isContaining(searchText, row.getSchemaName(), row.getSchemaGroup());
            }
        });
        UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
        ArrayList<UxOffline> offlines = new ArrayList<UxOffline>();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        try {
            snapshots = engine.getAllOfflineSnapshots(queryContext.asRuntimeContext());
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] could not retrieve the schema snapshots", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SNAPSHOT_RETRIEVAL_ERROR, (Serializable[])new Serializable[0]));
        }
        if (snapshots != null) {
            for (Map.Entry entry : snapshots.entrySet()) {
                File schemaFactoryFile = (File)entry.getKey();
                OlapSchemaFactoryInfo schemaInfo = engine.getSchemaFactoryInfo(queryContext.asRuntimeContext(), schemaFactoryFile);
                List schemaSnapshots = (List)entry.getValue();
                for (OlapSnapshotFile schemaSnapshot : schemaSnapshots) {
                    UxOffline offline = new UxOffline(schemaInfo, schemaSnapshot);
                    if (rowSearcher != null && !rowSearcher.isAccepting(offline) || rowFilters != null && !rowFilters.isAccepting(offline)) continue;
                    offlines.add(offline);
                }
            }
        }
        offlines.sort((o1, o2) -> {
            String o2_group;
            String o1_group = CdStringUtils.isNotNullAndNotBlank((String)o1.getSchemaGroup()) ? o1.getSchemaGroup() : "\uffff";
            int cmp = o1_group.compareTo(o2_group = CdStringUtils.isNotNullAndNotBlank((String)o2.getSchemaGroup()) ? o2.getSchemaGroup() : "\uffff");
            if (cmp == 0) {
                int cmp_ = o1.getSchemaName().compareTo(o2.getSchemaName());
                if (cmp_ == 0) {
                    return o1.getName().compareTo(o2.getName());
                }
                return cmp_;
            }
            return cmp;
        });
        int totalRowCount = offlines.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (UxOffline offline : offlines) {
            rows.add(UxOfflinesQuery.createRow(queryContext, offline));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, UxOffline schema) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(schema.getSchemaGroup()));
        UxUseCase useCase = UxOfflineInfoQueryMeta.createUseCase(context, schema.getName());
        cells.add(new UxTableCell((Object)schema.getSchemaName(), useCase));
        cells.add(new UxTableCell(UxOfflinesQuery.offlineCaptionAsDate(babylon, schema.getName())).withValue_(UxOfflinesQuery.offlineTimestamp(schema.getName())));
        cells.add(new UxTableCell(schema.getName()));
        UxStyleLevel style = CdStringUtils.isNullOrBlank((String)schema.getSchemaName()) ? UxStyleLevel.ERROR : null;
        String tooltip = style == UxStyleLevel.ERROR ? context.getUxBabylonService().translate("offlineSnapshotSchemaFactoryMissing", new Serializable[0]) : null;
        return new UxTableRow(cells).withStyle(style).withTooltip(tooltip);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Offlines));
    }
}

