/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.offline;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOffline;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflineInfoQueryMeta;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxOfflineInfoQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String name;
    @Nullable
    private UxOffline offline;

    protected UxOfflineInfoQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String name, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
        this.name = name;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineComponent engine;
        OlapSnapshotFile offline_;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        if (CdStringUtils.isNotNullAndNotBlank((String)this.name) && (offline_ = (engine = queryContext.getOlapEngineComponent()).getOfflineSnapshot(queryContext.asRuntimeContext(), this.name)) != null) {
            OlapSchemaFactoryInfo schema = engine.getSchemaFactoryInfo(queryContext.asRuntimeContext(), offline_.getFactory());
            this.offline = new UxOffline(schema, offline_);
        }
        if (this.offline == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SNAPSHOT_UNKNOWN, (Serializable[])new Serializable[]{this.name}));
        }
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        List<UxTableRow> rows = this.setupRows(queryContext, this.offline);
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    private List<UxTableRow> setupRows(UxQueryContext queryContext, UxOffline offline) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "name"), offline.getName()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schema"), offline.getSchemaName()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "group"), offline.getSchemaGroup()));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "timestamp"), UxOfflineInfoQuery.offlineCaptionAsDate(babylon, offline.getName())));
        long size = offline.getSize(queryContext.getVfs());
        if (size != -1L) {
            String size_ = CdSizeUtils.format((Locale)babylon.getLocale(), (double)size);
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "size"), size_));
        }
        return rows;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxOfflineInfoQueryMeta.createUseCase(queryContext, this.offline != null ? this.offline.getName() : null));
    }
}

