/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.offline;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDeleteOfflineQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String name;

    protected UxDeleteOfflineQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String name) {
        super(meta, requestId);
        this.name = name;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (CdStringUtils.isNullOrBlank((String)this.name)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SNAPSHOT_MISSING, (Serializable[])new Serializable[0]));
        }
        OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
        CdVFileSystem vfs = directories.getVfs();
        File snapshots = directories.getOfflineDirectory();
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)vfs, (File)snapshots);
        OlapFile snapshot = fs.create(this.name);
        boolean deleted = vfs.delete(snapshot.__getUnderlying());
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] schema snapshot deleted [" + this.name + "] [" + deleted + "]"));
        return UxReply.actionSuccess(new UxActionPerformed(deleted));
    }
}

