/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.admin.queries.schema.UxExtendedErrors;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflineInfoQueryMeta;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class UxSchemaCreateOfflineQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String schemaFile;

    protected UxSchemaCreateOfflineQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable Integer timeoutS, String schemaFile) {
        super(meta, requestId, timeoutS);
        this.schemaFile = schemaFile;
    }

    @Override
    public String getSchemaLifeCycleName() {
        return this.schemaFile;
    }

    @Override
    public OlapFile getSchemaFactoryFileName(UxServerRequestContext context) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaFile)) {
            return context.createSchemaFactoryFile(false, this.schemaFile);
        }
        return null;
    }

    @Override
    public boolean isCreateOfflineOnly() {
        return true;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isFullLoadSchema() {
        return true;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineContext = queryContext.getOlapEngineRequestContext();
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(engineContext);
        File schemaFactoryFile = queryContext.createSchemaFactoryFile(false, this.schemaFile).__getUnderlying();
        OlapEngineLoadSchemaParams params = new OlapEngineLoadSchemaParams(schemaFactoryFile, false, -1, -1, OlapEngineOfflineMode.WRITE_ONLY, null, false);
        OlapSchemaLifeCycleStatus status = helper.loadSchema((IOlapEngineLoadSchemaParams)params);
        UxExtendedErrors errors = new UxExtendedErrors();
        if (status.isError()) {
            errors = UxSchemaCreateOfflineQuery.getErrorForActiveRequest(queryContext, status.getSchema(), schemaFactoryFile, "sch_createOfflineError");
        }
        UxSchemaLifeCycleStatus lifeCycleStatus = new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus(), null, errors.errors, errors.vMessage, errors.vMessages);
        OlapSchema schema = engineContext.getLoadedSchemaPhaseI();
        OlapSchemaInformation info = schema != null ? schema.getInformation() : null;
        String offline = info != null ? info.getWrittenOfflineSnapshot() : null;
        UxActionContinuation continuation = offline != null ? new UxActionContinuation(UxActionContinuationKind.NAVIGATE, UxOfflineInfoQueryMeta.createUseCase(queryContext, offline)) : null;
        return UxReply.actionSuccess((UxActionResult)lifeCycleStatus, continuation);
    }
}

