/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.admin.queries.schema.UxExtendedErrors;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxRestoreOfflineQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String name;
    private final int waitS;
    private final int cancelS;
    @Nullable
    private OlapSnapshotFile snapshot;
    @Nullable
    private String schemaName;
    @Nullable
    private UxSchemaFactoryFile schemaFactoryFile;

    protected UxRestoreOfflineQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable Integer timeoutS, String name, int waitS, int cancelS) {
        super(meta, requestId, timeoutS);
        this.name = name;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.LOAD;
    }

    @Override
    @Nullable
    public String getSchemaLifeCycleName() {
        return this.schemaName;
    }

    @Override
    @Nullable
    public OlapFile getSchemaFactoryFileName(UxServerRequestContext context) {
        return this.schemaFactoryFile != null ? this.schemaFactoryFile.asOlapFile() : null;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isFullLoadSchema() {
        return true;
    }

    @Override
    public void initialize(UxServerRequestContext requestContext) {
        super.initialize(requestContext);
        if (CdStringUtils.isNotNullAndNotBlank((String)this.name)) {
            OlapSchemaFactoryInfo schema;
            File factory;
            OlapEngineComponent engine = requestContext.getOlapEngineComponent();
            this.snapshot = engine.getOfflineSnapshot(requestContext.asRuntimeContext(), this.name);
            if (this.snapshot != null && (factory = this.snapshot.getFactory()) != null && (schema = engine.getSchemaFactoryInfo(requestContext.asRuntimeContext(), factory)) != null) {
                this.schemaName = schema.getName();
                this.schemaFactoryFile = UxSchemaFactoryFile.fromFile(requestContext, false, schema.getFile());
            }
        }
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxUseCase loadedSchemaUC;
        OlapRuntimeContext rContext;
        OlapEngineComponent engine;
        OlapSchemaInformation loadedSchema;
        if (this.snapshot == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SNAPSHOT_UNKNOWN, (Serializable[])new Serializable[]{this.name}));
        }
        if (this.schemaFactoryFile == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SNAPSHOT_MISSING_FACTORY, (Serializable[])new Serializable[]{this.name}));
        }
        OlapEngineRequestContext engineContext = queryContext.getOlapEngineRequestContext();
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(engineContext);
        String absPath = this.snapshot.getPath();
        File schemaFactoryFile_ = this.schemaFactoryFile.asOlapFile().__getUnderlying();
        OlapEngineLoadSchemaParams params = new OlapEngineLoadSchemaParams(schemaFactoryFile_, false, this.waitS, this.cancelS, OlapEngineOfflineMode.READ, absPath, false);
        OlapSchemaLifeCycleStatus status = helper.loadSchema((IOlapEngineLoadSchemaParams)params);
        UxExtendedErrors errors = new UxExtendedErrors();
        if (status.isError()) {
            errors = UxRestoreOfflineQuery.getErrorForActiveRequest(queryContext, status.getSchema(), schemaFactoryFile_, "sch_restoreOfflineError");
        }
        UxSchemaLifeCycleStatus result = new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus(), null, errors.errors, errors.vMessage, errors.vMessages);
        UxActionContinuation continuation = null;
        if (!status.isError() && (loadedSchema = (engine = queryContext.getOlapEngineComponent()).getLoadedSchemaInformation(rContext = queryContext.asRuntimeContext(), this.schemaName)) != null && (loadedSchemaUC = UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(queryContext, loadedSchema, null, null)) != null) {
            continuation = new UxActionContinuation(UxActionContinuationKind.NAVIGATE, loadedSchemaUC);
        }
        return UxReply.actionSuccess((UxActionResult)result, continuation);
    }
}

