/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxLoadSchemaQuery;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import org.jetbrains.annotations.Nullable;

public class UxLoadSchemaQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxLoadSchemaQueryMeta LoadSchema = new UxLoadSchemaQueryMeta();

    public UxLoadSchemaQueryMeta() {
        super(UxConsoleConstants.QueryName.LoadSchema);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        Integer timeoutS = params.getIntegerParameter("timeoutS");
        UxSchemaId schemaId = params.getExistingSchemaIdParameter();
        boolean incrLoad = params.getBooleanParameter("incrLoad");
        boolean keepMdxResultCache = params.getBooleanParameter("keepMdxResultCache");
        boolean forceBackup = params.getBooleanParameter("forceBackup");
        int waitS = params.getIntegerParameter("waitS", -1);
        int cancelS = params.getIntegerParameter("cancelS", -1);
        return new UxLoadSchemaQuery(this, params.getRequestId(), timeoutS, schemaId, incrLoad, keepMdxResultCache, forceBackup, waitS, cancelS);
    }

    public UxUrl createQueryUrl(String schemaFile) {
        return this.createQueryUrl().addParam("schemaFile", schemaFile);
    }

    @Nullable
    public static UxAction createFullReloadAction(UxQueryContext context, String factoryFileName) {
        UxUrl url = LoadSchema.createQueryUrl(factoryFileName);
        return new UxActionBuilder(context, LoadSchema).withId("FullReloadSchema").withOkCancel().withUrl(url).withProgressInfo(UxLoadSchemaQueryMeta.createProgressInfoAction(context), UxLoadSchemaQueryMeta.createProgressInfoActionRefreshS(context), UxLoadSchemaQueryMeta.createProgressContinuationAction(context)).build();
    }

    @Nullable
    public static UxAction createLoadAction(UxQueryContext context, String factoryFileName) {
        UxUrl url = LoadSchema.createQueryUrl(factoryFileName);
        return new UxActionBuilder(context, LoadSchema).withId("LoadSchema").withOkCancel().withUrl(url).withProgressInfo(UxLoadSchemaQueryMeta.createProgressInfoAction(context), UxLoadSchemaQueryMeta.createProgressInfoActionRefreshS(context), UxLoadSchemaQueryMeta.createProgressContinuationAction(context)).build();
    }

    @Nullable
    public static UxAction createIncrLoadAction(UxQueryContext context, String factoryFileName) {
        UxBabylonService babylon = context.getUxBabylonService();
        UxUrl url = LoadSchema.createQueryUrl(factoryFileName);
        return new UxActionBuilder(context, LoadSchema).withId("IncrLoadSchema").withOkCancel().withUrl(url).withParams(new UxField(babylon, "incrLoad", new UxFieldMeta(UxFieldTypes.BOOLEAN, false, true, true), new UxFieldValue(true)), new UxField(babylon, "keepMdxResultCache", new UxFieldMeta(UxFieldTypes.BOOLEAN, true, false, false), new UxFieldValue(false))).withProgressInfo(UxLoadSchemaQueryMeta.createProgressInfoAction(context), UxLoadSchemaQueryMeta.createProgressInfoActionRefreshS(context), UxLoadSchemaQueryMeta.createProgressContinuationAction(context)).build();
    }
}

