/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.lifecycle;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.command.builtin.OlapLoadSchemaHelper;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxExtendedErrors;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxAbstractSchemaLifeCycleQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class UxLoadSchemaCreateOfflineQuery
extends UxAbstractSchemaLifeCycleQuery {
    private final String schemaFile;
    private final int waitS;
    private final int cancelS;

    protected UxLoadSchemaCreateOfflineQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable Integer timeoutS, String schemaFile, int waitS, int cancelS) {
        super(meta, requestId, timeoutS);
        this.schemaFile = schemaFile;
        this.waitS = waitS;
        this.cancelS = cancelS;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.LOAD;
    }

    @Override
    public String getSchemaLifeCycleName() {
        return this.schemaFile;
    }

    @Override
    public OlapFile getSchemaFactoryFileName(UxServerRequestContext context) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaFile)) {
            return context.createSchemaFactoryFile(false, this.schemaFile);
        }
        return null;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isFullLoadSchema() {
        return true;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineContext = queryContext.getOlapEngineRequestContext();
        OlapLoadSchemaHelper helper = new OlapLoadSchemaHelper(engineContext);
        File schemaFactoryFile = queryContext.createSchemaFactoryFile(false, this.schemaFile).__getUnderlying();
        OlapEngineLoadSchemaParams params = new OlapEngineLoadSchemaParams(schemaFactoryFile, false, this.waitS, this.cancelS, OlapEngineOfflineMode.WRITE, null, false);
        OlapSchemaLifeCycleStatus status = helper.loadSchema((IOlapEngineLoadSchemaParams)params);
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        OlapSchemaInformation info = engine.getLoadedSchemaInformation(rContext, schemaFactoryFile);
        String extra = null;
        if (info != null) {
            extra = info.getWrittenOfflineSnapshot();
        }
        UxExtendedErrors errors = new UxExtendedErrors();
        if (status.isError()) {
            errors = UxLoadSchemaCreateOfflineQuery.getErrorForActiveRequest(queryContext, status.getSchema(), schemaFactoryFile, "sch_loadCreateOfflineError");
        }
        return UxReply.actionSuccess(new UxSchemaLifeCycleStatus(status.getSchema(), status.getLoadStatus(), extra, errors.errors, errors.vMessage, errors.vMessages));
    }
}

