/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDownloadBackupQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String schemaName;
    @Nullable
    private final String timestamp;

    protected UxDownloadBackupQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaName, @Nullable String timestamp) {
        super(meta, requestId);
        this.schemaName = schemaName;
        this.timestamp = timestamp;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        File zip;
        if (CdStringUtils.isNullOrBlank((String)this.schemaName) || CdStringUtils.isNullOrBlank((String)this.timestamp)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.schemaName + "/" + this.timestamp}));
        }
        M_BackupManager manager = queryContext.getBackupManager();
        try {
            zip = manager.exportBackup(this.schemaName, this.timestamp);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] unexpected error while compressing the backup [" + this.schemaName + "][" + this.timestamp + "]"), (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{"[" + this.schemaName + "][" + this.timestamp + "]", ex.getMessage()}));
        }
        String mimeType = queryContext.getMimeTypeByExtension(zip.getName());
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)zip.getParentFile());
        OlapFile zip_ = fs.create(zip.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(zip_, zip.getName(), mimeType, true);
        String attachmentName = this.schemaName + " " + this.timestamp + ".zip";
        return new UxAttachmentReply(wrapper, attachmentName);
    }
}

