/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfo;
import crazydev.iccube.cluster.master.backup.save.M_DeleteBackupInfos;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;

public class UxCleanAllBackupsQuery
extends UxAbstractSchemaQuery {
    protected UxCleanAllBackupsQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        M_BackupManager backupManager = queryContext.getBackupManager();
        M_DeleteBackupInfos deleted = backupManager.cleanAllBackups();
        StringBuilder backupsDeleteMessage = new StringBuilder();
        boolean backupsDeleted = false;
        for (M_DeleteBackupInfo info : deleted.getInfos()) {
            OlapLoggers.UX_REQUEST.debug((Object)"[UX] schema backup deleted [%s] [%s]".formatted(info.getSchema(), info.getTimestamp()));
            if (!info.isDeleted()) continue;
            backupsDeleted = true;
            if (!backupsDeleteMessage.isEmpty()) {
                backupsDeleteMessage.append("|");
            }
            backupsDeleteMessage.append(info.getTimestamp());
        }
        return UxReply.actionSuccess(new UxActionPerformed(backupsDeleted, backupsDeleteMessage.toString()));
    }
}

