/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema.backup;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupInfoQuery;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupsQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxDeleteBackupQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxDeleteBackupsQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxDownloadBackupQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxRestoreBackupQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBackupInfoQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxBackupInfoQueryMeta BackupInfo = new UxBackupInfoQueryMeta();

    private UxBackupInfoQueryMeta() {
        super(UxConsoleConstants.QueryName.BackupInfo);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxBackupsQueryMeta.Backups.isAuthorized(context);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String schema = params.getStringParameter("schemaName");
        String timestamp = params.getStringParameter("timestamp");
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxBackupInfoQuery(this, params.getRequestId(), schema, timestamp, tableOptions);
    }

    public UxUrl createQueryUrl(String schema, String timestamp) {
        return this.createQueryUrl().addParam("schemaName", schema).addParam("timestamp", timestamp);
    }

    static UxUseCase createUseCase(UxQueryContext context, @Nullable String schema, @Nullable String timestamp, @Nullable UxSchemaFactoryFile factoryFile) {
        UxBabylonService babylon = context.getUxBabylonService();
        String childCaption = null;
        List<UxAction> actions = null;
        if (schema != null && timestamp != null && factoryFile != null) {
            childCaption = schema + " / " + timestamp;
            actions = BackupInfo.createActions(context);
            actions.add(UxRestoreBackupQueryMeta.createAction(context, schema, timestamp, factoryFile));
            actions.add(UxDownloadBackupQueryMeta.createAction(context, schema, timestamp));
            actions.add(UxDeleteBackupQueryMeta.createAction(context, schema, timestamp));
            actions.add(UxDeleteBackupsQueryMeta.createAction(context, schema));
        }
        return new UxUseCaseBuilder(context, BackupInfo).withId(UxAdminUseCaseName.BackupInfo.name() + "-" + schema + "-" + timestamp).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.BackupInfo.name(), new Serializable[0])).withUrl(BackupInfo.createQueryUrl(schema, timestamp)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Backups), childCaption, UxAdminUseCaseRepository.asBookmark(BackupInfo.createQueryUrl(schema, timestamp)))).withActions(actions).build(true);
    }
}

