/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaStatus;
import crazydev.iccube.ux.admin.queries.schema.UxUnloadedSchema;
import crazydev.iccube.ux.admin.queries.utils.UxRowFilters;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxUnloadedSchemasQuery
extends UxAbstractSchemaQuery {
    protected UxUnloadedSchemasQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "group", "schema", "schemaDefinitionUpdateTime", "schemaStatus");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<UxUnloadedSchema>("group", babylon.translate("filterSchemaGroup", new Serializable[0]), UxUnloadedSchema::getGroup), new UxFilterMeta<UxUnloadedSchema>("schema", babylon.translate("filterSchemaName", new Serializable[0]), UxUnloadedSchema::getName));
        UxTableSearcher rowSearcher = this.setupRowSearcher(this.tableOptions, new UxTableRowSearcher<UxUnloadedSchema>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(UxUnloadedSchema row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getGroup());
            }
        });
        UxRowFilters rowFilters = this.setupRowFilters(this.tableOptions, filterMetas);
        ArrayList unloadedSchemas = new ArrayList();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        engine.foreachSchemaFactoryFile(rContext, factoryFile -> {
            OlapSchemaFactoryInfo unloadedSchema;
            if (!engine.isSchemaLoaded(rContext, factoryFile) && !engine.isSchemaLoading(rContext, factoryFile) && (unloadedSchema = engine.getSchemaFactoryInfo(rContext, factoryFile)) != null) {
                UxUnloadedSchema schema = new UxUnloadedSchema(factoryFile, unloadedSchema);
                if ((rowSearcher == null || rowSearcher.isAccepting(schema)) && (rowFilters == null || rowFilters.isAccepting(schema))) {
                    unloadedSchemas.add(schema);
                }
            }
            return true;
        });
        unloadedSchemas.sort((o1, o2) -> -Long.compare(o1.factoryFile.lastModified(), o2.factoryFile.lastModified()));
        int totalRowCount = unloadedSchemas.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schema", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (UxUnloadedSchema unloadedSchema : unloadedSchemas) {
            rows.add(UxUnloadedSchemasQuery.createRow(queryContext, unloadedSchema));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(true, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, UxUnloadedSchema schema) {
        UxStyleLevel styleLevel;
        String status;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapEngineComponent engine = context.getOlapEngineComponent();
        OlapRuntimeContext rContext = context.asRuntimeContext();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(schema.getGroup()));
        UxUseCase useCase = UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(context, null, schema.getName(), UxSchemaFactoryFile.fromFile(context, false, schema.factoryFile));
        cells.add(new UxTableCell((Object)schema.getName(), useCase));
        long lastEditedTime = schema.factoryFile.lastModified();
        String lastEditedTime_ = lastEditedTime > 0L ? UxUtils.formatTimeServer(babylon, new Date(lastEditedTime)) : "";
        cells.add(new UxTableCell(lastEditedTime_).withValue_(lastEditedTime));
        if (!engine.isSchemaLoading(rContext, schema.factoryFile)) {
            String uiErrors = UxUnloadedSchemasQuery.getLatestErrors(context, schema.getName(), schema.factoryFile);
            status = uiErrors != null ? babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.UNLOADED_REFRESH_FAILED.name()) : babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.UNLOADED.name());
            styleLevel = uiErrors != null ? UxStyleLevel.ERROR : UxStyleLevel.INFO;
        } else {
            status = babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADING.name());
            styleLevel = UxStyleLevel.INFO;
        }
        cells.add(new UxTableCell(status));
        return new UxTableRow(cells).withStyle(styleLevel);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.UnloadedSchemas));
    }
}

