/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestsQuery;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaStatus;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSchemaInfoQuery
extends UxAbstractSchemaQuery {
    private final UxSchemaId schemaId;
    @Nullable
    private final String schemaName;
    @Nullable
    private final String factoryFileName;
    @Nullable
    private OlapSchemaInformation loadingSchema;
    @Nullable
    private OlapSchemaInformation loadedSchema;
    private IOlapBuilderSchemaDefFactory unloadedSchema;
    @Nullable
    private OlapBuilderError invalidSchema;

    protected UxSchemaInfoQuery(UxQueryMeta meta, OlapRequestId requestId, UxSchemaId schemaId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
        this.schemaId = schemaId;
        this.schemaName = schemaId.schemaName;
        this.factoryFileName = schemaId.schemaFile;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.NONE;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (CdStringUtils.isNullOrBlank((String)this.schemaName) && CdStringUtils.isNullOrBlank((String)this.factoryFileName)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_UNKNOWN, (Serializable[])new Serializable[]{""}));
        }
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaName)) {
            this.loadingSchema = engine.getLoadingSchemaInformation(rContext, this.schemaName);
        } else if (CdStringUtils.isNotNullAndNotBlank((String)this.factoryFileName)) {
            this.loadingSchema = engine.getLoadingSchemaInformation(rContext, queryContext.createSchemaFactoryFile(false, this.factoryFileName).__getUnderlying());
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)this.schemaName)) {
            this.loadedSchema = engine.getLoadedSchemaInformation(rContext, this.schemaName);
        } else if (CdStringUtils.isNotNullAndNotBlank((String)this.factoryFileName)) {
            this.loadedSchema = engine.getLoadedSchemaInformation(rContext, queryContext.createSchemaFactoryFile(false, this.factoryFileName).__getUnderlying());
        }
        if (this.loadingSchema == null && this.loadedSchema == null && CdStringUtils.isNotNullAndNotBlank((String)this.factoryFileName)) {
            try {
                File factoryFile = queryContext.createSchemaFactoryFile(false, this.factoryFileName).__getUnderlying();
                if (factoryFile.exists() && factoryFile.isFile()) {
                    this.unloadedSchema = engine.unmarshallXmlFactory(queryContext.asRuntimeContext(), factoryFile);
                }
            }
            catch (OlapBuilderErrorException ex) {
                this.invalidSchema = ex.getError();
                return this.executeQueryForInvalid(queryContext);
            }
        }
        if (this.loadingSchema != null) {
            return this.executeQueryForLoading(queryContext);
        }
        if (this.loadedSchema != null || this.unloadedSchema != null) {
            return this.executeQueryForLoadedUnloaded(queryContext);
        }
        if (this.invalidSchema != null) {
            return this.executeQueryForInvalid(queryContext);
        }
        return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_UNKNOWN, (Serializable[])new Serializable[]{CdStringUtils.isNotNullAndNotBlank((String)this.schemaName) ? this.schemaName : this.factoryFileName}));
    }

    private UxReply executeQueryForLoading(UxQueryContext context) {
        IOlapBuilderSchemaDefFactory factory = this.loadingSchema.getFactory();
        String uuid = this.loadingSchema.getRequestUuid();
        UxBabylonService babylon = context.getUxBabylonService();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.create(babylon.translate("name", new Serializable[0]), factory.getSchemaName()));
        UxStyleLevel styleLevel = UxStyleLevel.INFO;
        String status = babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADING.name());
        rows.add(UxTableRow.create(babylon.translate("status", new Serializable[0]), status).withStyle(styleLevel));
        rows.add(UxTableRow.createAsPreValue(babylon.translate("schemaLoadRequest", new Serializable[0]), uuid));
        IcCubeRequestStatusManager manager = context.getRequestStatusManager();
        IcCubeRequestStatus requestStatus = manager.getRequestStatus(uuid);
        if (requestStatus != null) {
            String progressInformation = requestStatus.getLocalizedProgressInformation(context.getOlapBabylonService());
            rows.add(UxTableRow.create(babylon.translate("status", new Serializable[0]), requestStatus.getLocalizedState(context.getOlapBabylonService())).withStyle(UxRequestsQuery.getStyleLevel(requestStatus)));
            rows.add(UxTableRow.createAsPreValue(babylon.translate("progress", new Serializable[0]), progressInformation == null ? "" : progressInformation));
            rows.add(UxTableRow.create(babylon.translate("startTime", new Serializable[0]), requestStatus.getStartDateServerTimeForRequest()));
            List details = requestStatus.getAllDetails(10);
            for (IcCubeRequestStatus.Detail detail : details) {
                rows.add(UxTableRow.createAsPreValue(detail.getName(), detail.getValue()));
            }
            List backupErrors = manager.getBackupErrors(requestStatus.getRequestUUID());
            if (!backupErrors.isEmpty()) {
                Object rawValue = "";
                for (CdError error : backupErrors) {
                    rawValue = (String)rawValue + error.asMessage((CdBabylonService)context.getOlapBabylonService()) + "\n";
                }
                rows.add(UxTableRow.createAsPreValue(babylon.translate("backupError", new Serializable[0]), (String)rawValue).withStyle(UxStyleLevel.ERROR));
            }
            List tableProcessingDetails = requestStatus.getTableProcessingDetails();
            for (IcCubeRequestStatus.Detail detail : tableProcessingDetails) {
                rows.add(UxTableRow.createAsPreValue(detail.getName(), detail.getValue()));
            }
            List errors = manager.getErrors(requestStatus.getRequestUUID());
            if (!errors.isEmpty()) {
                Object rawValue = "";
                for (CdError error : errors) {
                    rawValue = (String)rawValue + error.asMessage((CdBabylonService)context.getOlapBabylonService()) + "\n";
                }
                rows.add(UxTableRow.createAsPreValue(babylon.translate("error", new Serializable[0]), (String)rawValue).withStyle(UxStyleLevel.ERROR));
            }
        }
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    private UxReply executeQueryForLoadedUnloaded(UxQueryContext context) {
        String uiErrors;
        String offline;
        boolean incrLoadDeActivatedOnError;
        boolean incrLoadActive;
        IOlapBuilderSchemaDefFactory schemaFactory = this.loadedSchema != null ? this.loadedSchema.getFactory() : this.unloadedSchema;
        OlapEngineComponent engine = context.getOlapEngineComponent();
        OlapRuntimeContext rContext = context.asRuntimeContext();
        UxBabylonService babylon = context.getUxBabylonService();
        boolean isForRestApi = context.isForRestApi();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        String schemaName_ = this.loadedSchema != null ? this.loadedSchema.getName() : schemaFactory.getSchemaName();
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "name"), schemaName_));
        File schemaFactoryFile = schemaFactory.getXmlFile();
        String uiErrors2 = UxSchemaInfoQuery.getLatestErrors(context, schemaName_, schemaFactoryFile);
        String status = this.loadedSchema != null ? (uiErrors2 != null ? babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADED_REFRESH_FAILED.name()) : babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADED.name())) : (uiErrors2 != null ? babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.UNLOADED_REFRESH_FAILED.name()) : babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.UNLOADED.name()));
        UxStyleLevel styleLevel = uiErrors2 != null ? UxStyleLevel.ERROR : UxStyleLevel.INFO;
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "status"), status).withStyle(styleLevel));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "description"), schemaFactory.getSchemaDescription()));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "group"), schemaFactory.getSchemaGroup()));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaLoadOnStartup"), babylon.translateYesNo(schemaFactory.isLoadOnStartup())));
        if (this.loadedSchema != null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaLoadRequest"), this.loadedSchema.getRequestUuid()));
        }
        if (this.loadedSchema != null) {
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaDataUpdateTime"), UxUtils.formatTimeServer(babylon, this.loadedSchema.getLastDataUpdatedTime())));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaRefreshTimeStart"), UxUtils.formatTimeServer(babylon, this.loadedSchema.getRefreshTimeStart())));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaRefreshTimeEnd"), UxUtils.formatTimeServer(babylon, this.loadedSchema.getRefreshTimeEnd())));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaLoadTime"), UxSchemaInfoQuery.formatMillis(babylon, this.loadedSchema.getLoadTime())));
        }
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaNextRefreshTime"), this.getNextRefreshTime(context, schemaFactoryFile)));
        if (this.loadedSchema != null) {
            incrLoadActive = this.loadedSchema.isIncremental();
            incrLoadDeActivatedOnError = this.loadedSchema.isIncrLoadDeActivatedOnError();
        } else {
            incrLoadActive = schemaFactory.incrementalLoadActive();
            incrLoadDeActivatedOnError = false;
        }
        if (incrLoadActive) {
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaIncrLoad"), babylon.translateYesNo(true)));
            String status2 = !isForRestApi ? (incrLoadDeActivatedOnError ? babylon.translate("schemaIncrLoadDeactivatedOnError", new Serializable[0]) : babylon.translate("schemaIncrLoadOk", new Serializable[0])) : (incrLoadDeActivatedOnError ? babylon.translate("INCR_LOAD_DEACTIVATED_ON_ERROR", new Serializable[0]) : babylon.translate("INCR_LOAD_OK", new Serializable[0]));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaIncrLoadStatus"), status2).withStyle(incrLoadDeActivatedOnError ? UxStyleLevel.ERROR : UxStyleLevel.INFO));
        }
        if (this.loadedSchema != null) {
            if (this.loadedSchema.getRestoredBackupTimestampD() != null) {
                rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaRestoredBackup"), UxUtils.formatTimeServer(babylon, this.loadedSchema.getRestoredBackupTimestampD())));
            }
            if (this.loadedSchema.getBackupStatus() != null) {
                rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaBackupStatus"), this.loadedSchema.getBackupStatus()));
            }
            if (this.loadedSchema.getBackupError() != null) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaBackupError"), this.loadedSchema.getBackupError()).withStyle(UxStyleLevel.ERROR));
            }
        }
        if (this.loadedSchema != null && (offline = UxSchemaInfoQuery.offlineCaption(babylon, engine.getOfflineSnapshot(rContext, schemaFactoryFile), schemaName_, schemaFactoryFile.getAbsolutePath())) != null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaOffline"), offline));
        }
        if (schemaFactoryFile != null) {
            UxSchemaFactoryFile factoryFile = UxSchemaFactoryFile.fromFile(context, false, schemaFactoryFile);
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaFactoryFile"), factoryFile.relativePath()));
        }
        if (this.loadedSchema != null && this.loadedSchema.getMmapDirectoryForStats() != null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaMmapDirectory"), this.loadedSchema.getMmapDirectoryForStats()));
        }
        if (this.loadedSchema != null) {
            OlapSchemaStats stats = engine.getLoadedSchemaStatistics(rContext, this.loadedSchema.getName());
            long totalRamSize = stats != null ? stats.getTotalRamSize() : -1L;
            String totalRamSize_ = totalRamSize != -1L ? CdSizeUtils.format((double)totalRamSize) : "-";
            String overview = stats != null ? stats.print(true) : "-";
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schemaRAM"), totalRamSize_));
            if (!context.isForRestApi()) {
                rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaStats"), overview));
            }
        }
        if ((uiErrors = UxSchemaInfoQuery.getLatestErrors(context, schemaName_, schemaFactoryFile)) != null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaErrors"), uiErrors).withStyle(UxStyleLevel.ERROR));
        }
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    private UxReply executeQueryForInvalid(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        boolean isForRestApi = context.isForRestApi();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        if (this.factoryFileName == null) {
            throw new RuntimeException("internal error: missing invalid schema factory file name");
        }
        UxSchemaFactoryFile factoryFile = UxSchemaFactoryFile.fromRelativePath(context, false, this.factoryFileName);
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaFactoryFile"), factoryFile.relativePath()));
        if (this.invalidSchema != null) {
            String uiError = this.invalidSchema.asMessage((CdBabylonService)context.getOlapBabylonService());
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "schemaErrors"), uiError).withStyle(UxStyleLevel.ERROR));
        }
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        UxUseCase useCase;
        if (this.loadingSchema != null) {
            IOlapBuilderSchemaDefFactory factory = this.loadingSchema.getFactory();
            String uuid = this.loadingSchema.getRequestUuid();
            useCase = UxSchemaInfoQueryMeta.createUseCaseForLoading(queryContext, uuid, factory.getSchemaName(), UxSchemaFactoryFile.fromFile(queryContext, false, factory.getXmlFile()));
        } else if (this.loadedSchema != null || this.unloadedSchema != null) {
            IOlapBuilderSchemaDefFactory factory = this.loadedSchema != null ? this.loadedSchema.getFactory() : this.unloadedSchema;
            useCase = UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(queryContext, this.loadedSchema, factory.getSchemaName(), UxSchemaFactoryFile.fromFile(queryContext, false, factory.getXmlFile()));
        } else {
            useCase = this.invalidSchema != null && this.factoryFileName != null ? UxSchemaInfoQueryMeta.createUseCaseForInvalid(queryContext, UxSchemaFactoryFile.fromRelativePath(queryContext, false, this.factoryFileName)) : UxSchemaInfoQueryMeta.createUseCaseForNothing(queryContext);
        }
        reply.withUseCase(useCase);
    }
}

