/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxDownloadSchemaFileQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFileQuery;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSchemaFileQueryMeta
extends UxAbstractSchemaQueryMeta {
    public static final UxSchemaFileQueryMeta SchemaFile = new UxSchemaFileQueryMeta();

    public UxSchemaFileQueryMeta() {
        super(UxConsoleConstants.QueryName.SchemaFile);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(new UxAction[0]);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String schemaFile = params.getExistingStringParameter("schemaFile");
        return new UxSchemaFileQuery((UxQueryMeta)this, params.getRequestId(), schemaFile);
    }

    public UxUrl createQueryUrl(String schemaFile) {
        return this.createQueryUrl().addParam("schemaFile", schemaFile);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, String filePath) {
        UxUseCase useCase = UxSchemaFileQueryMeta.createUseCase(context, filePath);
        return new UxActionBuilder(context, SchemaFile).withUseCase(useCase).build();
    }

    static UxUseCase createUseCase(UxQueryContext context, @Nullable String filePath) {
        List<UxAction> actions = null;
        if (filePath != null) {
            actions = SchemaFile.createActions(context);
            actions.add(UxDownloadSchemaFileQueryMeta.createAction(context, filePath));
        }
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxUseCaseBuilder(context, SchemaFile).withId(UxAdminUseCaseName.SchemaFile.name() + "-" + filePath).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.SchemaFile.name(), new Serializable[]{filePath})).withUrl(SchemaFile.createQueryUrl(filePath)).withActions(actions).build(true);
    }
}

