/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaStatus;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxLoadedSchemasQuery
extends UxAbstractSchemaQuery {
    protected UxLoadedSchemasQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "group", "schema", "schemaDataUpdateTime", "schemaRefreshTimeStart", "schemaRAM", "schemaStatus");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<OlapSchemaInformation>("group", babylon.translate("filterSchemaGroup", new Serializable[0]), OlapSchemaInformation::getGroup), new UxFilterMeta<OlapSchemaInformation>("schema", babylon.translate("filterSchemaName", new Serializable[0]), OlapSchemaInformation::getName));
        UxTableRowSearcher<OlapSchemaInformation> searcher = new UxTableRowSearcher<OlapSchemaInformation>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(OlapSchemaInformation row, String searchText) {
                return this.isContaining(searchText, row.getName(), row.getGroup());
            }
        };
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        List loadedSchemas = this.filter(this.tableOptions, searcher, filterMetas, engine.getAllSchemaInformation(rContext));
        int totalRowCount = loadedSchemas.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schema", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (OlapSchemaInformation loadedSchema : loadedSchemas) {
            rows.add(UxLoadedSchemasQuery.createRow(queryContext, loadedSchema));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, OlapSchemaInformation schema) {
        UxStyleLevel styleLevel;
        String status;
        UxBabylonService babylon = context.getUxBabylonService();
        OlapEngineComponent engine = context.getOlapEngineComponent();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(schema.getGroup()));
        UxUseCase useCase = UxSchemaInfoQueryMeta.createUseCaseForLoadedUnloaded(context, schema, null, null);
        cells.add(new UxTableCell((Object)schema.getName(), useCase));
        Date dataUpdateTime = schema.getLastDataUpdatedTime();
        String dataUpdateTime_ = UxUtils.formatTimeServer(babylon, dataUpdateTime);
        cells.add(new UxTableCell(dataUpdateTime_).withValue_(dataUpdateTime));
        Date refreshTimeStart = schema.getRefreshTimeStart();
        String refreshTimeStart_ = UxUtils.formatTimeServer(babylon, refreshTimeStart);
        cells.add(new UxTableCell(refreshTimeStart_).withValue_(refreshTimeStart));
        OlapRuntimeContext rContext = context.asRuntimeContext();
        OlapSchemaStats stats = engine.getLoadedSchemaStatistics(rContext, schema.getName());
        long totalRamSize = stats != null ? stats.getTotalRamSize() : -1L;
        String totalRamSize_ = totalRamSize != -1L ? CdSizeUtils.formatEx((Locale)babylon.getLocale(), (double)totalRamSize) : null;
        cells.add(new UxTableCell(totalRamSize_).withStyle(UxStylePresentation.SIZE).withValue_(totalRamSize));
        if (!engine.isSchemaLoading(rContext, schema.getFactoryFile())) {
            String uiErrors = UxLoadedSchemasQuery.getLatestErrors(context, schema.getName(), schema.getFactoryFile());
            status = uiErrors != null ? babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADED_REFRESH_FAILED.name()) : babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADED.name());
            styleLevel = uiErrors != null ? UxStyleLevel.ERROR : UxStyleLevel.INFO;
        } else {
            status = babylon.translateEnum(UxSchemaStatus.class, UxSchemaStatus.LOADING.name());
            styleLevel = UxStyleLevel.INFO;
        }
        cells.add(new UxTableCell(status));
        return new UxTableRow(cells).withStyle(styleLevel);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.LoadedSchemas));
    }
}

