/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaInfoQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class UxInvalidSchemasQuery
extends UxAbstractSchemaQuery {
    protected UxInvalidSchemasQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId, tableOptions);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "schemaFactoryFile");
        ArrayList invalidSchemas = new ArrayList();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        engine.foreachSchemaFactoryFile(rContext, factoryFile -> {
            try {
                engine.unmarshallXmlFactory(rContext, factoryFile);
            }
            catch (OlapBuilderErrorException ignored) {
                invalidSchemas.add(UxSchemaFactoryFile.fromFile(queryContext, false, factoryFile));
            }
            return true;
        });
        int totalRowCount = invalidSchemas.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schemaFactoryFile", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (UxSchemaFactoryFile invalidSchema : invalidSchemas) {
            rows.add(UxInvalidSchemasQuery.createRow(queryContext, invalidSchema));
        }
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(table));
    }

    private static UxTableRow createRow(UxQueryContext context, UxSchemaFactoryFile schema) {
        String path = schema.relativePath();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxSchemaInfoQueryMeta.createUseCaseForInvalid(context, schema);
        cells.add(new UxTableCell((Object)path, useCase));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.InvalidSchemas));
    }
}

