/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.schema.UxAbstractSchemaQuery;
import crazydev.iccube.ux.common.action.UxActionPerformed;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class UxDumpSchemaIndexQuery
extends UxAbstractSchemaQuery {
    @Nullable
    private final String schemaName;

    protected UxDumpSchemaIndexQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String schemaName) {
        super(meta, requestId);
        this.schemaName = schemaName;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        try {
            if (queryContext.getApplicationContext().getRuntime().isIDEA() && this.schemaName != null) {
                queryContext.dumpSchemaIndex(this.schemaName);
                return UxReply.actionSuccess(new UxActionPerformed(true));
            }
            return UxReply.actionSuccess(new UxActionPerformed(false));
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[DumpSchemaIndex] error", (Throwable)ex);
            return UxReply.actionSuccess(new UxActionPerformed(false, ex.getMessage()));
        }
    }
}

