/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.schema;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.gwt.server.requesthandler.monitoring.schemas.GwtOfflineSnapshotHelper;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtOfflineSnapshot;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSnapshotFile;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.schema.UxExtendedErrors;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class UxAbstractSchemaQuery
extends UxAdminQuery {
    @Nullable
    protected final UxTableOptions tableOptions;

    protected UxAbstractSchemaQuery(UxQueryMeta meta, OlapRequestId requestId) {
        this(meta, requestId, null);
    }

    protected UxAbstractSchemaQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    public static String formatMillis(UxBabylonService babylon, @Nullable Long ms) {
        if (ms == null) {
            return "-";
        }
        return CdTimeUtils.formatMillis((long)ms);
    }

    public String getNextRefreshTime(UxQueryContext context, File factoryFile) {
        long nextScheduledTimeMS;
        IcCubeScheduler scheduler = context.getScheduler(IcCubeSchedulerKind.SCHEMAS);
        IcCubeSchedulerJob job = scheduler.getActiveScheduledJobForLoadSchema(context.asRuntimeContext(), factoryFile);
        long l = nextScheduledTimeMS = job != null ? job.getNextScheduledTimeMS() : -1L;
        if (nextScheduledTimeMS == -1L) {
            return UxUtils.formatNextTimeServer(context.getUxBabylonService(), null);
        }
        return UxUtils.formatNextTimeServer(context.getUxBabylonService(), new Date(nextScheduledTimeMS));
    }

    @Nullable
    public static String offlineCaption(UxBabylonService babylon, @Nullable String offlineSnapshot, @Nullable String schemaName, String schemaFactory) {
        if (offlineSnapshot == null) {
            return null;
        }
        String size = "n/a";
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", babylon.getLocale());
        GwtOfflineSnapshot info = GwtOfflineSnapshotHelper.generateCaption(df, new OlapSnapshotFile(offlineSnapshot, offlineSnapshot), schemaName, schemaFactory, "n/a", true);
        return info.getCaption();
    }

    public static String offlineCaptionAsDate(UxBabylonService babylon, String snapshot) {
        long millis = UxAbstractSchemaQuery.offlineTimestamp(snapshot);
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", babylon.getLocale());
        String caption = df.format(new Date(millis));
        return caption;
    }

    public static long offlineTimestamp(String snapshot) {
        long millis = OlapBuilderOfflineHelper.getNameMillis((String)snapshot);
        return millis;
    }

    @Nullable
    public static String getLatestErrors(UxQueryContext context, String schemaName, File factoryFile) {
        OlapRuntimeContext rContext;
        Map permsErrors;
        OlapEngineComponent engine = context.getOlapEngineComponent();
        IcCubeRequestStatusManager requestStatusManager = context.getRequestStatusManager();
        IcCubeRequestStatusManager.LatestErrors loadingErrors = requestStatusManager.getLatestErrorsForSchemaDefFactory(factoryFile);
        StringBuilder uiErrors = new StringBuilder();
        if (loadingErrors != null && !loadingErrors.getErrors().isEmpty()) {
            for (CdError error : loadingErrors.getErrors()) {
                uiErrors.append(error.asMessage((CdBabylonService)context.getOlapBabylonService()) + "\n");
            }
        }
        if ((permsErrors = engine.getLoadedSchemaPermsErrors(rContext = context.asRuntimeContext(), schemaName)) != null) {
            for (Map.Entry entry : permsErrors.entrySet()) {
                String roleName = (String)entry.getKey();
                for (CdError error : (List)entry.getValue()) {
                    uiErrors.append("[role: " + roleName + " ] " + error.asMessage((CdBabylonService)context.getOlapBabylonService()) + "\n");
                }
            }
        }
        return uiErrors.length() > 0 ? uiErrors.toString() : null;
    }

    public static UxExtendedErrors getErrorForActiveRequest(UxQueryContext context, String schemaName, File factoryFile, String vMessageTag) {
        OlapRuntimeContext rContext;
        Map permsErrors;
        OlapEngineComponent engine = context.getOlapEngineComponent();
        IcCubeRequestStatusManager requestStatusManager = context.getRequestStatusManager();
        List loadingErrors = requestStatusManager.getErrorForActiveRequestForSchemaDefFactory(factoryFile);
        ArrayList<String> uiErrors = new ArrayList<String>();
        ArrayList<UxValidationMessage> vMessages = new ArrayList<UxValidationMessage>();
        if (loadingErrors != null && !loadingErrors.isEmpty()) {
            for (CdError error : loadingErrors) {
                uiErrors.add(error.asMessage((CdBabylonService)context.getOlapBabylonService()));
                vMessages.add(UxUtils.setupValidationMessage(context, context.getOlapBabylonService(), error));
            }
        }
        if ((permsErrors = engine.getLoadedSchemaPermsErrors(rContext = context.asRuntimeContext(), schemaName)) != null) {
            for (Map.Entry entry : permsErrors.entrySet()) {
                String roleName = (String)entry.getKey();
                for (CdError error : (List)entry.getValue()) {
                    uiErrors.add("[role: " + roleName + " ] " + error.asMessage((CdBabylonService)context.getOlapBabylonService()));
                    vMessages.add(UxUtils.setupValidationMessage(context, context.getOlapBabylonService(), error, "[role: " + roleName + " ] "));
                }
            }
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String vMessage = babylon.translate(vMessageTag, new Serializable[]{schemaName});
        return new UxExtendedErrors(!uiErrors.isEmpty() ? uiErrors : null, vMessage, !vMessages.isEmpty() ? vMessages : null);
    }
}

