/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.scheduler.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadProperty;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJobLogicMode;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobMode;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobStatus;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxScheduledJob {
    public static final CdProperty STATUS = new CdReadProperty(UxScheduledJob.class, "status", CdProperty.Access.FIELD);
    public static final CdProperty NEXT_TRIGGER_TIME = new CdReadProperty(UxScheduledJob.class, "nextTriggerTime", CdProperty.Access.FIELD);
    public static final CdProperty LATEST_REQUEST_UUID = new CdReadProperty(UxScheduledJob.class, "latestRequestUUID", CdProperty.Access.FIELD);
    public static final CdProperty ERRORS = new CdReadProperty(UxScheduledJob.class, "errors", CdProperty.Access.FIELD);
    private final UxScheduledJobStatus status;
    @Nullable
    private final UxScheduledJobMode mode;
    private final long nextTriggerTimeMS;
    private final String nextTriggerTime;
    @Nullable
    private final String latestRequestUUID;
    @Nullable
    private final UxValidationResult errors;

    private UxScheduledJob() {
        this.status = null;
        this.mode = null;
        this.nextTriggerTimeMS = -1L;
        this.nextTriggerTime = null;
        this.latestRequestUUID = null;
        this.errors = null;
    }

    public UxScheduledJob(UxScheduledJobStatus status) {
        this(status, null, -1L, "-", null, null);
    }

    private UxScheduledJob(UxScheduledJobStatus status, @Nullable UxScheduledJobMode mode, long nextTriggerTimeMS, String nextTriggerTime, @Nullable String latestRequestUUID, @Nullable UxValidationResult errors) {
        this.status = status;
        this.mode = mode;
        this.nextTriggerTimeMS = nextTriggerTimeMS;
        this.nextTriggerTime = nextTriggerTime;
        this.latestRequestUUID = latestRequestUUID;
        this.errors = errors;
    }

    public static UxScheduledJob create(UxQueryContext context, @Nullable IcCubeSchedulerJob job) {
        boolean disabled;
        if (job == null) {
            return new UxScheduledJob(UxScheduledJobStatus.DISABLED);
        }
        IcCubeSchedulerJobDefinition def = job.getDefinition();
        boolean bl = disabled = !def.isEnabled();
        UxScheduledJobStatus status = disabled ? UxScheduledJobStatus.DISABLED : (job.isDone() ? UxScheduledJobStatus.DONE : UxScheduledJobStatus.ENABLED);
        IcCubeSchedulerJobLogicMode mode = disabled ? job.getOutOfBandMode() : job.getMode();
        UxScheduledJobMode modeUX = mode != null ? mode.toUX() : null;
        long nextTriggerTimeMS_ = !job.isDone() ? job.getNextScheduledTimeMS() : -1L;
        Date nextTriggerTime_ = nextTriggerTimeMS_ != -1L ? new Date(nextTriggerTimeMS_) : null;
        String nextTriggerTime = UxUtils.formatNextTimeServer(context.getUxBabylonService(), nextTriggerTime_);
        String latestRequestUUID = job.getLatestRequestUuid();
        List<OlapContextualError> errors_ = job.getErrors();
        UxValidationResult errors = errors_ != null && !errors_.isEmpty() ? UxUtils.setupValidationResult(context, context.getOlapBabylonService(), errors_) : null;
        return new UxScheduledJob(status, modeUX, nextTriggerTimeMS_, nextTriggerTime, latestRequestUUID, errors);
    }

    public UxScheduledJobStatus getStatus() {
        return this.status;
    }

    @Nullable
    public UxScheduledJobMode getMode() {
        return this.mode;
    }

    @Nullable
    public String getLatestRequestUUID() {
        return this.latestRequestUUID;
    }

    public long getNextTriggerTimeMS() {
        return this.nextTriggerTimeMS;
    }

    public String getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.hasErrors();
    }
}

