/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.scheduler.common;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxCronSchedule;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.spi.OperableTrigger;

public class UxCronQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final String expression;

    protected UxCronQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String expression) {
        super(meta, requestId);
        this.expression = expression;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        ArrayList<String> schedule = new ArrayList<String>();
        if (this.expression == null || CdStringUtils.isNullOrBlank((String)this.expression)) {
            schedule.add(babylon.translate("cronExpressionMissing", new Serializable[0]));
        } else {
            try {
                CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)this.expression);
                TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity("ic3-quartz-trigger", "ic3").withSchedule((ScheduleBuilder)cronScheduleBuilder).forJob("ic3-quartz-job");
                CronTrigger cronTrigger = (CronTrigger)builder.build();
                OperableTrigger trigger = (OperableTrigger)cronTrigger;
                trigger.validate();
                schedule.addAll(this.createSchedule(babylon, trigger));
            }
            catch (SchedulerException ex) {
                OlapLoggers.SCHEDULER.error((Object)("[SCHEDULER] cron expression [" + this.expression + "] error"), (Throwable)ex);
                schedule.add(babylon.translate("cronExpressionError", new Serializable[]{ex.getMessage()}));
            }
            catch (RuntimeException ex) {
                OlapLoggers.SCHEDULER.error((Object)("[SCHEDULER] cron expression [" + this.expression + "] error"), (Throwable)ex);
                String message = ex.getMessage();
                Throwable cause = ex.getCause();
                if (cause != null) {
                    message = cause.getMessage();
                }
                schedule.add(babylon.translate("cronExpressionError", new Serializable[]{message}));
            }
        }
        return UxReply.actionSuccess(new UxCronSchedule(schedule));
    }

    private List<String> createSchedule(UxBabylonService babylon, OperableTrigger trigger) {
        ArrayList<String> schedule = new ArrayList<String>();
        Date next = new Date();
        boolean terminated = false;
        for (int dd = 0; dd < 100; ++dd) {
            if ((next = trigger.getFireTimeAfter(next)) == null) {
                terminated = true;
                break;
            }
            schedule.add(next.toString());
        }
        if (!terminated && trigger.getFireTimeAfter(next) == null) {
            terminated = true;
        }
        if (!terminated) {
            schedule.add(babylon.translate("cronExpressionContd", new Serializable[0]));
        } else {
            schedule.add(babylon.translate("cronExpressionEnd", new Serializable[0]));
        }
        return schedule;
    }
}

