/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.scheduler.common;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.alerts.UxSaveAlertsFileQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.UxSaveSchemasScheduleFileQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableOptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public abstract class UxAbstractSchedulerQuery
extends UxAdminQuery {
    @Nullable
    protected final UxTableOptions tableOptions;

    protected UxAbstractSchedulerQuery(UxQueryMeta meta, OlapRequestId requestId) {
        this(meta, requestId, null);
    }

    protected UxAbstractSchedulerQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    protected UxReply getDefinitionFile(UxQueryContext queryContext, IcCubeSchedulerKind schedulerKind) {
        OlapFile file = queryContext.getSchedulerDefinitionFile(schedulerKind);
        String mimeType = queryContext.getMimeTypeByExtension(file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file, file.getName(), mimeType, false);
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper, switch (schedulerKind) {
            case IcCubeSchedulerKind.ALERTS -> UxSaveAlertsFileQueryMeta.createAction(queryContext);
            case IcCubeSchedulerKind.SCHEMAS -> UxSaveSchemasScheduleFileQueryMeta.createAction(queryContext);
            default -> throw new RuntimeException("internal error: unexpected scheduler kind [" + String.valueOf((Object)schedulerKind) + "]");
        });
    }

    protected UxReply downloadDefinitionFile(UxQueryContext queryContext, IcCubeSchedulerKind schedulerKind) {
        OlapFile file = queryContext.getSchedulerDefinitionFile(schedulerKind);
        if (!file.exists()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{file.getName()}));
        }
        String mimeType = queryContext.getMimeTypeByExtension(file.getName());
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file, file.getName(), mimeType, false);
        return new UxAttachmentReply(wrapper, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UxReply saveDefinitionFile(UxQueryContext queryContext, IcCubeSchedulerKind schedulerKind, @Nullable String fileContent) {
        UxReply uxReply;
        if (fileContent == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{"missing file content"}));
        }
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
            IcCubeScheduler scheduler = queryContext.getScheduler(schedulerKind);
            scheduler.importAndScheduleDefinitionX(queryContext.asRuntimeContext(), null, in);
            uxReply = UxReply.actionSuccess();
        }
        catch (IcCubeSchedulerDefinitionErrorException ex) {
            UxReply uxReply2;
            try {
                OlapLoggers.UX_REQUEST.error((Object)("[UX] " + schedulerKind.nameLC() + " deployment error"), (Throwable)((Object)ex));
                uxReply2 = UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{ex.getLocalizedMessage()}));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return uxReply2;
        }
        IOUtils.closeQuietly((InputStream)in);
        return uxReply;
    }
}

