/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.scheduler;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.contextual.OlapContextualError;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.gwt.shared.portlets.monitoring.command.schemas.GwtSchemaLoadStatus;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerLoadSchemaJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerJob;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.scheduler.UxSchemaScheduleQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJob;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJobStatus;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxSchemasScheduleQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxSchemasScheduleQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapRuntimeContext rContext;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.SCHEMAS);
        List<OlapContextualError> errors = scheduler.getApplyDefinitionErrors(rContext = queryContext.asRuntimeContext());
        if (errors != null && !errors.isEmpty()) {
            return UxReply.validationErrors(UxUtils.setupValidationResult(queryContext, queryContext.getOlapBabylonService(), errors));
        }
        UxTableHeaders header = UxTableHeaders.create(babylon, "schema", "description", "status", "errors", "nextTriggerTime");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IcCubeSchedulerLoadSchemaJobDefinition>("schema", babylon.translate("filterSchemaScheduleSchema", new Serializable[0]), IcCubeSchedulerLoadSchemaJobDefinition::getSchemaName), new UxFilterMeta<IcCubeSchedulerJobDefinition>("status", babylon.translate("filterSchemaScheduleStatus", new Serializable[0]), UxEnumFilterType.create(babylon, UxScheduledJobStatus.class), row -> {
            UxScheduledJob job = (UxScheduledJob)row.getScheduledInfo();
            return job != null ? job.getStatus() : null;
        }));
        UxTableRowSearcher<IcCubeSchedulerLoadSchemaJobDefinition> searcher = new UxTableRowSearcher<IcCubeSchedulerLoadSchemaJobDefinition>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(IcCubeSchedulerLoadSchemaJobDefinition row, String searchText) {
                return this.isContaining(searchText, row.getSchemaName(), row.getDescription());
            }
        };
        IdentityHashMap<IcCubeSchedulerJobDefinition, IcCubeSchedulerJob> jobs = new IdentityHashMap<IcCubeSchedulerJobDefinition, IcCubeSchedulerJob>();
        List<IcCubeSchedulerJobDefinition> definitions_ = scheduler.getScheduleJobDefinitions(rContext);
        for (IcCubeSchedulerJobDefinition definition : definitions_) {
            IcCubeSchedulerJob job = scheduler.getScheduledJob(rContext, definition);
            UxScheduledJob jobUX = UxScheduledJob.create(queryContext, job);
            definition.setScheduledInfo(jobUX);
            jobs.put(definition, job);
            if (!(definition instanceof IcCubeSchedulerLoadSchemaJobDefinition)) continue;
            IcCubeSchedulerLoadSchemaJobDefinition load = (IcCubeSchedulerLoadSchemaJobDefinition)definition;
            OlapFile factoryFile = queryContext.createSchemaFactoryFile(false, load.getSchemaFactoryFileName());
            OlapEngineComponent engine = queryContext.getOlapEngineComponent();
            OlapSchemaFactoryInfo info = engine.getSchemaFactoryInfo(rContext, factoryFile.__getUnderlying());
            String schemaName = info != null ? info.getName() : null;
            load.setSchemaName(schemaName);
        }
        List<IcCubeSchedulerJobDefinition> definitions = this.filter(this.tableOptions, searcher, filterMetas, definitions_);
        int totalRowCount = definitions.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), "schema", UxTableSortType.asc, totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (IcCubeSchedulerJobDefinition definition : definitions) {
            rows.add(UxSchemasScheduleQuery.createRow(queryContext, jobs, definition));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, Map<IcCubeSchedulerJobDefinition, IcCubeSchedulerJob> jobs, IcCubeSchedulerJobDefinition definition) {
        UxBabylonService babylon = context.getUxBabylonService();
        IcCubeSchedulerLoadSchemaJobDefinition schedule = (IcCubeSchedulerLoadSchemaJobDefinition)definition;
        UxScheduledJob jobUX = (UxScheduledJob)schedule.getScheduledInfo();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(schedule.getSchemaName()));
        String latestRequestUuid = jobUX != null ? jobUX.getLatestRequestUUID() : null;
        UxUseCase useCase = UxSchemaScheduleQueryMeta.createUseCase(context, schedule.getUuid(), schedule.getDescription(), latestRequestUuid);
        String description = schedule.getDescription();
        cells.add(new UxTableCell((Object)(CdStringUtils.isNotNullAndNotBlank((String)description) ? description : schedule.getUuid()), useCase));
        UxScheduledJobStatus status = jobUX != null ? jobUX.getStatus() : null;
        cells.add(new UxTableCell(status != null ? babylon.translateEnum(UxScheduledJobStatus.class, status.name()) : null).withValue_((Object)status));
        boolean hasErrors = UxSchemasScheduleQuery.hasError(jobs, schedule);
        cells.add(new UxTableCell(hasErrors ? babylon.translate("yesL", new Serializable[0]) : babylon.translate("noL", new Serializable[0])));
        String nextTriggerTime = jobUX != null ? jobUX.getNextTriggerTime() : "-";
        long nextTriggerTimeMS = jobUX != null ? jobUX.getNextTriggerTimeMS() : -1L;
        cells.add(new UxTableCell(nextTriggerTime).withValue_(nextTriggerTimeMS));
        UxStyleLevel styleLevel = hasErrors ? UxStyleLevel.ERROR : null;
        return new UxTableRow(cells).withStyle(styleLevel);
    }

    private static boolean hasError(Map<IcCubeSchedulerJobDefinition, IcCubeSchedulerJob> jobs, IcCubeSchedulerLoadSchemaJobDefinition schedule) {
        boolean hasErrorUX;
        UxScheduledJob jobUX = (UxScheduledJob)schedule.getScheduledInfo();
        boolean bl = hasErrorUX = jobUX != null && jobUX.hasErrors();
        if (hasErrorUX) {
            return true;
        }
        IcCubeSchedulerJob job = jobs.get(schedule);
        if (job == null) {
            return false;
        }
        GwtSchemaLoadStatus status = job.getLatestLoadStatus();
        if (status == null) {
            return false;
        }
        return !status.isLoaded();
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.SchemasSchedule));
    }
}

