/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.scheduler;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.scheduler.definition.IcCubeSchedulerJobDefinition;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.scheduler.UxSaveSchemaScheduleQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.UxSchemaScheduleQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxAbstractSchedulerQuery;
import crazydev.iccube.ux.admin.queries.scheduler.common.UxScheduledJob;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSchemaScheduleQuery
extends UxAbstractSchedulerQuery {
    @Nullable
    private String uuid;
    @Nullable
    private IcCubeSchedulerJobDefinition jobDefinition;
    @Nullable
    private String requestUuid;

    protected UxSchemaScheduleQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_SCHEDULE_UNKNOWN, (Serializable[])new Serializable[]{""}));
        }
        OlapRuntimeContext rContext = queryContext.asRuntimeContext();
        IcCubeScheduler scheduler = queryContext.getScheduler(IcCubeSchedulerKind.SCHEMAS);
        int revNumber = scheduler.getCurrentRevNumber(rContext);
        this.jobDefinition = scheduler.getScheduleJobDefinition(rContext, this.uuid);
        if (this.jobDefinition == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.SCHEMA_SCHEDULE_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        String loadSchemaUUID = this.uuid;
        UxScheduledJob job = UxScheduledJob.create(queryContext, scheduler.getScheduledJob(rContext, loadSchemaUUID));
        this.requestUuid = job.getLatestRequestUUID();
        this.jobDefinition.setScheduledInfo(job);
        UxModel model = queryContext.convertToUxModel(revNumber, this.jobDefinition);
        UxAction save = UxSaveSchemaScheduleQueryMeta.createAction(queryContext, false, loadSchemaUUID);
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxSchemaScheduleQueryMeta.createUseCase(queryContext, this.uuid, this.jobDefinition != null ? this.jobDefinition.getDescription() : null, this.requestUuid));
    }
}

