/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.status;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class UxThreadDumpQuery
extends UxAdminQuery {
    protected UxThreadDumpQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        ThreadInfo[] infos;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] ids = bean.findDeadlockedThreads();
        if (ids != null && ids.length > 0) {
            out.println("-------------------------------------------------------------------------------------");
            out.println("deadlock(s)");
            out.println("-------------------------------------------------------------------------------------");
            out.println();
            for (long id : ids) {
                ThreadInfo info = bean.getThreadInfo(id);
                out.print(info.toString());
            }
            out.println();
        }
        out.println("-------------------------------------------------------------------------------------");
        out.println("full thread dump");
        out.println("-------------------------------------------------------------------------------------");
        out.println();
        for (ThreadInfo info : infos = bean.dumpAllThreads(true, true)) {
            out.print(info.toString());
        }
        out.println();
        out.println("__");
        out.println();
        out.flush();
        out.close();
        UxFileWrapper wrapper = UxFileWrapper.forBinary("thread-dump.txt", bytes.toByteArray(), "text/plain");
        return new UxAttachmentReply(wrapper, null);
    }
}

