/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.status;

import crazydev.common.utils.CdOperatingSystemUtils;
import crazydev.common.utils.CdOsUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.cluster.master.local.M_LocalCluster;
import crazydev.iccube.cluster.node.engine.N_OlapEngine;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutorsManager;
import crazydev.iccube.olap.eval.evaluator.monitoring.OlapMdxExecutorMonitoring;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.util.OlapOOM;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import crazydev.iccube.server.common.IcCubeGarbageCollectorActivity;
import crazydev.iccube.server.configuration.ai.IcCubeAIConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.version.IcCubeServerVersion;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;

public class UxServerStatusQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;
    private final boolean download;

    protected UxServerStatusQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, boolean download) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
        this.download = download;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        Integer count;
        String name;
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
        if (OlapOOM.oom) {
            values.put(!isForRestApi ? "Out of Memory" : "oom", babylon.translate("oom", new Serializable[0]));
        }
        if (queryContext.isPrintServerSetupOnError()) {
            values.put(!isForRestApi ? "Print Server Setup on Error" : "printServerSetupOnError", "true");
        }
        values.put(!isForRestApi ? "PID" : "pid", "" + ManagementFactory.getRuntimeMXBean().getPid());
        OlapEngineApplicationContext engineAppContext = appContext.getOlapEngineApplicationContext();
        OlapEngineComponent engineComponent = engineAppContext.getOlapEngineComponent();
        OlapLixContent lix = engineComponent.getLixContent();
        Date expiry = lix.getNotAfter();
        if (expiry != null) {
            values.put(!isForRestApi ? "License Valid Until" : "licValidUntil", expiry.toString());
        } else {
            values.put(!isForRestApi ? "License Valid Until" : "licValidUntil", "perpetual");
        }
        values.put(!isForRestApi ? "icCube Server Version" : "icCubeServerVersion", IcCubeServerVersion.get().toString());
        String version = UxServerStatusQuery.createDashboardsVersion(queryContext);
        if (version != null) {
            values.put(!isForRestApi ? "icCube Dashboards Version" : "icCubeDashboardsVersion", version);
        } else {
            values.put(!isForRestApi ? "icCube Dashboards Version" : "icCubeDashboardsVersion", !isForRestApi ? babylon.translate("dashboardsAppNotAvailable", new Serializable[0]) : "dashboardsAppNotAvailable");
        }
        LocalDate rToday = CdTimeUtils.redefinedToday();
        if (rToday != null) {
            values.put(!isForRestApi ? "Server MDX Today" : "mdxToday", rToday.toString());
        }
        values.put(!isForRestApi ? "Server OS" : "os", CdOsUtils.getOsName());
        values.put(!isForRestApi ? "Server Current Time" : "currentTime", UxUtils.formatTimeServer(babylon, new Date()));
        values.put(!isForRestApi ? "Server Available Processors" : "availableProcessors", CdSystemUtils.availableProcessorsForLogs());
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        double value = osBean.getSystemLoadAverage();
        values.put(!isForRestApi ? "System Load" : "systemLoad", "" + value);
        long value2 = CdOperatingSystemUtils.getTotalPhysicalMemorySize();
        if (value2 != -1L) {
            values.put(!isForRestApi ? "Server Total Physical Memory" : "totalPhysicalMemory", CdSizeUtils.format((double)value2));
        }
        if ((value2 = CdOperatingSystemUtils.getFreePhysicalMemorySize()) != -1L) {
            values.put(!isForRestApi ? "Server Free Physical Memory" : "freePhysicalMemory", CdSizeUtils.format((double)value2));
        }
        if ((value2 = CdOperatingSystemUtils.getTotalSwapSpaceSize()) != -1L) {
            values.put(!isForRestApi ? "Server Total Swap Memory" : "totalSwapMemory", CdSizeUtils.format((double)value2));
        }
        if ((value2 = CdOperatingSystemUtils.getFreeSwapSpaceSize()) != -1L) {
            values.put(!isForRestApi ? "Server Free Swap Memory" : "freeSwapMemory", CdSizeUtils.format((double)value2));
        }
        values.put(!isForRestApi ? "Unmap Supported" : "unmapSupported", "" + CdSystemUtils.UNMAP_SUPPORTED);
        values.put(!isForRestApi ? "Unmap Activated" : "unmapActivated", "" + CdSystemUtils.UNMAP_ACTIVATED);
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        values.put(!isForRestApi ? "icCube Startup Time" : "startupTime", String.valueOf(new Date(rtBean.getStartTime())));
        values.put(!isForRestApi ? "icCube Uptime" : "uptime", CdTimeUtils.formatMillis(null, (String)" ", (long)rtBean.getUptime()));
        values.put(!isForRestApi ? "icCube Maximum Memory" : "maxMemory", CdSizeUtils.format((double)Runtime.getRuntime().maxMemory()));
        values.put(!isForRestApi ? "icCube Total Memory" : "totalMemory", CdSizeUtils.format((double)Runtime.getRuntime().totalMemory()));
        values.put(!isForRestApi ? "icCube Free Memory" : "freeMemory", CdSizeUtils.format((double)Runtime.getRuntime().freeMemory()));
        List<IcCubeGarbageCollectorActivity> garbageCollectorActivities = appContext.getGcActivities();
        for (IcCubeGarbageCollectorActivity activity : garbageCollectorActivities) {
            values.put("GC: " + activity.getName(), activity.getCount() + " ( " + CdTimeUtils.formatMillis((long)activity.getTotalTimeMS()) + " )");
        }
        int httpSessionCount = appContext.getHttpSessionCount();
        int xmlaSessionCount = appContext.getXmlaSessionCount();
        OlapCacheManager cacheManager = appContext.getCacheManager();
        int icCubeSessionCount = cacheManager.getSessionCount();
        M_LocalCluster cluster = appContext.getOlapEngineApplicationContext().getCluster();
        N_OlapEngine engine = cluster.getEngine();
        int mdxSessionCount = engine.getMdxSessionCount();
        values.put(!isForRestApi ? "icCube Sessions (HTTP)" : "sessionsHTTP", "" + httpSessionCount);
        values.put(!isForRestApi ? "icCube Sessions (XMLA)" : "sessionsXMLA", "" + xmlaSessionCount);
        values.put(!isForRestApi ? "icCube Sessions (MDX)" : "sessionsMDX", "" + mdxSessionCount);
        values.put(!isForRestApi ? "icCube Sessions (ic3)" : "sessionsIC3", "" + icCubeSessionCount);
        int icCubeUserCount = appContext.getAuthUserCount();
        values.put(!isForRestApi ? "icCube Users" : "users", "" + icCubeUserCount);
        IcCubeAIConfiguration ai = appContext.getAIConfiguration();
        values.put(!isForRestApi ? "AI" : "ai", "" + ai.isActive());
        if (ai.isActive()) {
            values.put(!isForRestApi ? "AI Request Timeout (Sec.)" : "aiRequestTimeoutS", "" + ai.getRequestTimeoutS());
            values.put(!isForRestApi ? "AI Model" : "aiModel", ai.getModel());
        }
        OlapEngineApplicationContext olapAppContext = appContext.getOlapEngineApplicationContext();
        int loadedSchemaCount = olapAppContext.getLoadedSchemaCount(queryContext.asRuntimeContext());
        values.put(!isForRestApi ? "Loaded Schema Count" : "loadedSchemaCount", "" + loadedSchemaCount);
        int schemaDataUpdateLongPollingRequestCount = appContext.getSchemaDataUpdateLongPollingRequestCount();
        values.put(!isForRestApi ? "Schema Data Update Long Polling Count" : "schemaDataUpdateLongPollingRequestCount", "" + schemaDataUpdateLongPollingRequestCount);
        OlapMdxExecutorsManager mdxExecutorManager = olapAppContext.getMdxExecutorsManager();
        OlapMdxExecutorMonitoring mdxMonitoring = mdxExecutorManager.getMonitoring();
        Map executorCounts = mdxMonitoring.getProfileCellExecutorCounts();
        for (Map.Entry entry : executorCounts.entrySet()) {
            name = (String)entry.getKey();
            count = (Integer)entry.getValue();
            values.put("MDX (cells) execution profile: " + name, "" + count);
        }
        executorCounts = mdxMonitoring.getProfileExtraExecutorCounts();
        for (Map.Entry entry : executorCounts.entrySet()) {
            name = (String)entry.getKey();
            count = (Integer)entry.getValue();
            values.put("MDX (extra) execution profile: " + name, "" + count);
        }
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            String value3 = (String)entry.getValue();
            rows.add(UxTableRow.createAsPreValue(key, value3));
        }
        UxTable table = UxTable.create(!this.download ? options : null, header, rows);
        if (this.download) {
            return new UxAttachmentReply(table.asFileWrapper(queryContext), "ic3-server-status.csv");
        }
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Nullable
    private static String createDashboardsVersion(UxQueryContext queryContext) {
        try {
            OlapDocsActualRepository repository = queryContext.getDocsRepository();
            OlapReportRepositoryRequestContext repReqCtxt = queryContext.createRepositoryContext();
            OlapRuntimeDashboardsVersion reportingVersion = repository.getDashboardsVersion(repReqCtxt);
            if (reportingVersion != null) {
                return reportingVersion.getVersionWithTimestampEx();
            }
            return null;
        }
        catch (RuntimeException ignored) {
            OlapLoggers.UX_REQUEST.warn((Object)"[UX] could not retrieve reporting version", (Throwable)ignored);
            return null;
        }
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.ServerStatus));
    }
}

