/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.request;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.ux.admin.queries.runtime.UxRuntimeQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxCancelAllRequestsQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxClearAllRequestsQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestsQuery;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxRequestsQueryMeta
extends UxRuntimeQueryMeta {
    public static final UxRequestsQueryMeta Requests = new UxRequestsQueryMeta();

    private UxRequestsQueryMeta() {
        super(UxConsoleConstants.QueryName.Requests);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        return super.isAuthorized(context) && perms.isMonitoringRequestsEnabled();
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context), UxCancelAllRequestsQueryMeta.createAction(context), UxClearAllRequestsQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxRequestsQuery(this, params.getRequestId(), tableOptions);
    }

    @Nullable
    public static UxAction createActiveQueries(UxQueryContext context) {
        return UxRequestsQueryMeta.createActionWithFilter(context, "state|ENUM|ACTIVE", "activeRequests");
    }

    @Nullable
    public static UxAction createMdxQueries(UxQueryContext context) {
        return UxRequestsQueryMeta.createActionWithFilter(context, "kind|ENUM|MDX", "mdxRequests");
    }

    @Nullable
    private static UxAction createActionWithFilter(UxQueryContext context, String filter, String filterTag) {
        UxUseCase useCase = new UxUseCaseBuilder(context, Requests).withId(UxAdminUseCaseName.Requests).withUrl(Requests.createQueryUrl().addParam("filter", filter)).build(true);
        if (useCase == null) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate(filterTag, new Serializable[0]);
        return new UxActionBuilder(context, Requests).withUseCase(useCase).withCaption(caption).build();
    }
}

