/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.request;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.status.IcCubeRequestState;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestState;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class UxRequestsQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxRequestsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = UxTableHeaders.create(babylon, "schema", "type", "status", "duration", "startTime", "endTime", "user", "progress");
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<IcCubeRequestStatus>("state", babylon.translate("filterRequestState", new Serializable[0]), UxEnumFilterType.create(babylon, UxRequestState.class), requestStatus -> UxRequestState.from(requestStatus.getState())), new UxFilterMeta<IcCubeRequestStatus>("kind", babylon.translate("filterRequestKind", new Serializable[0]), UxEnumFilterType.create(babylon, IcCubeRequestKind.class), IcCubeRequestStatus::getRequestKind), new UxFilterMeta<IcCubeRequestStatus>("mdx", babylon.translate("filterRequestMDX", new Serializable[0]), IcCubeRequestStatus::getMdx), new UxFilterMeta<IcCubeRequestStatus>("schema", babylon.translate("filterRequestSchema", new Serializable[0]), IcCubeRequestStatus::getSchema), new UxFilterMeta<IcCubeRequestStatus>("status", babylon.translate("filterRequestStatus", new Serializable[0]), UxEnumFilterType.create(babylon, IcCubeRequestState.class), IcCubeRequestStatus::getState), new UxFilterMeta<IcCubeRequestStatus>("user", babylon.translate("filterRequestUser", new Serializable[0]), IcCubeRequestStatus::getUserName));
        UxTableRowSearcher<IcCubeRequestStatus> searcher = new UxTableRowSearcher<IcCubeRequestStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(IcCubeRequestStatus row, String searchText) {
                return this.isContaining(searchText, row.getSchema(), row.getUserName(), row.getRequestUserFriendlyTypeName());
            }
        };
        IcCubeRequestStatusManager manager = queryContext.getRequestStatusManager();
        List activeRequests = this.filter(this.tableOptions, searcher, filterMetas, manager.getAllSortedActiveRequestStatus(this.getRequestId().getClientUUID()));
        List completedRequests = this.filter(this.tableOptions, searcher, filterMetas, manager.getAllSortedCompletedRequestStatus());
        int totalRowCount = activeRequests.size() + completedRequests.size();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.createForFirstPageWithDefaults(queryContext.getApi(), totalRowCount));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (IcCubeRequestStatus activeRequest : activeRequests) {
            rows.add(UxRequestsQuery.createRow(queryContext, activeRequest));
        }
        for (IcCubeRequestStatus completedRequest : completedRequests) {
            rows.add(UxRequestsQuery.createRow(queryContext, completedRequest));
        }
        UxTable table = UxTable.create(options, header, rows);
        List<UxTableRow> actualRows = table.getRows();
        if (actualRows != null) {
            for (UxTableRow actualRow : actualRows) {
                UxRequestsQuery.setupRowUseCase(queryContext, actualRow);
            }
        }
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas);
        return UxReply.success(new UxTableWithUseCasesReplyPayload(tableMeta, table));
    }

    private static UxTableRow createRow(UxQueryContext context, IcCubeRequestStatus status) {
        UxBabylonService babylon = context.getUxBabylonService();
        UxUseCase useCase = null;
        long elapsedTimeMs = status.getElapsedTimeMs();
        String progress = status.getLocalizedProgressInformation(context.getOlapBabylonService());
        UxStyleLevel styleLevel = UxRequestsQuery.getStyleLevel(status);
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(status.getSchema()));
        cells.add(new UxTableCell((Object)status.getRequestUserFriendlyTypeName(), useCase));
        cells.add(new UxTableCell(babylon.translateEnum(IcCubeRequestState.class, status.getState().name())).withValue_(status.getState()));
        cells.add(new UxTableCell(elapsedTimeMs != -1L ? CdTimeUtils.formatMillis((Locale)babylon.getLocale(), (long)elapsedTimeMs) : null).withValue_(elapsedTimeMs));
        cells.add(new UxTableCell(status.getStartDateServerTimeForRequest()).withValue_(status.getStartDate()));
        cells.add(new UxTableCell(status.getCompletionDateServerTimeFoRequest()).withValue_(status.getCompletionDate()));
        cells.add(new UxTableCell(status.getUserName()));
        cells.add(new UxTableCell(progress));
        String mdx = UxRequestsQuery.setupMdxDetails(status);
        UxTableRow row = new UxTableRow(cells).withStyle(styleLevel).withTooltip(mdx);
        row.setData(status);
        return row;
    }

    @Nullable
    private static String setupMdxDetails(IcCubeRequestStatus status) {
        List details = status.getAllDetails();
        for (IcCubeRequestStatus.Detail detail : details) {
            if (!(detail instanceof IcCubeRequestStatus.MdxDetail)) continue;
            IcCubeRequestStatus.MdxDetail details_ = (IcCubeRequestStatus.MdxDetail)detail;
            String mdx = details_.getValue();
            int maxSize = 8192;
            if (mdx.length() > 8192) {
                StringBuilder sb = new StringBuilder(mdx.substring(0, 8192)).append(" ...");
                return sb.toString();
            }
            return mdx;
        }
        return null;
    }

    private static void setupRowUseCase(UxQueryContext context, UxTableRow row) {
        IcCubeRequestStatus status = (IcCubeRequestStatus)row.getData();
        UxUseCase useCase = UxRequestQueryMeta.createUseCase(context, status.getRequestUUID(), status);
        row.setUseCase(useCase);
    }

    public static UxStyleLevel getStyleLevel(IcCubeRequestStatus status) {
        switch (status.getState()) {
            case COMPLETED_ON_ERROR: 
            case COMPLETED_ON_MDX_ERROR: {
                return UxStyleLevel.ERROR;
            }
            case COMPLETED_ON_CANCELLED: {
                return UxStyleLevel.CANCELLED;
            }
            case RECEIVED: 
            case PROCESSING_STARTED: 
            case PROCESSING_TASKS: 
            case CANCELLING: {
                return UxStyleLevel.ONGOING;
            }
        }
        return UxStyleLevel.INFO;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Requests));
    }
}

