/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.request;

import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.runtime.UxRuntimeQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxCancelRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxEditRequestMdxQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQuery;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestsQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxRequestQueryMeta
extends UxRuntimeQueryMeta {
    public static final UxRequestQueryMeta Request = new UxRequestQueryMeta();

    public UxRequestQueryMeta() {
        super(UxConsoleConstants.QueryName.Request);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxRequestsQueryMeta.Requests.isAuthorized(context);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        String uuid = params.getStringParameter("uuid");
        UxTableOptions tableOptions = params.getTableOptions();
        return new UxRequestQuery(this, params.getRequestId(), uuid, tableOptions);
    }

    public UxUrl createQueryUrl(String uuid) {
        return this.createQueryUrl().addParam("uuid", uuid);
    }

    @Nullable
    public static UxAction createActionForMonitor(UxQueryContext context) {
        UxUseCase useCase = new UxUseCaseBuilder(context, Request).withId(UxAdminUseCaseName.Request.name()).build(false);
        return new UxActionBuilder(context, Request).withUseCase(useCase).build();
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, IcCubeRequestStatus requestStatus) {
        return UxRequestQueryMeta.createAction(context, null, requestStatus);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, @Nullable String caption, IcCubeRequestStatus requestStatus) {
        UxUseCase useCase = UxRequestQueryMeta.createUseCase(context, requestStatus.getRequestUUID(), requestStatus);
        return new UxActionBuilder(context, Request).withCaption(caption).withUseCase(useCase).build();
    }

    public static UxUseCase createUseCase(UxQueryContext context, @Nullable String uuid, @Nullable IcCubeRequestStatus requestStatus) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = null;
        if (requestStatus != null) {
            uuid = requestStatus.getRequestUUID();
            actions = Request.createActions(context);
            IcCubeRequestStatusManager manager = context.getRequestStatusManager();
            if (manager.isActive(uuid)) {
                actions.add(UxCancelRequestQueryMeta.createAction(context, uuid, 1));
            }
            List details = requestStatus.getAllDetails();
            for (IcCubeRequestStatus.Detail detail : details) {
                if (!(detail instanceof IcCubeRequestStatus.MdxDetail)) continue;
                IcCubeRequestStatus.MdxDetail details_ = (IcCubeRequestStatus.MdxDetail)detail;
                String schema = details_.getSchema();
                String mdx = details_.getValue();
                actions.add(UxEditRequestMdxQueryMeta.createAction(context, schema, mdx));
            }
        }
        return new UxUseCaseBuilder(context, Request).withId(UxAdminUseCaseName.Request.name() + "-" + uuid).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.Request.name(), new Serializable[0])).withUrl(Request.createQueryUrl(uuid)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Requests), uuid, UxAdminUseCaseRepository.asBookmark(Request.createQueryUrl(uuid)))).withActions(actions).build(true);
    }

    public static UxUseCase createUseCaseForPrintingJob(UxQueryContext context, String uuid) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = Request.createActions(context);
        IcCubeRequestStatusManager manager = context.getRequestStatusManager();
        if (manager.isActive(uuid)) {
            actions.add(UxCancelRequestQueryMeta.createAction(context, uuid, 1));
        }
        return new UxUseCaseBuilder(context, Request).withId(UxAdminUseCaseName.Request.name() + "-" + uuid).withCaption(babylon.translateUseCaseCaption(UxAdminUseCaseName.Request.name(), new Serializable[0])).withUrl(Request.createQueryUrl(uuid)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Requests), uuid, UxAdminUseCaseRepository.asBookmark(Request.createQueryUrl(uuid)))).withActions(actions).build(true);
    }
}

