/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.request;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeActiveRequestManager;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestsQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxRequestQuery
extends UxAdminQuery {
    @Nullable
    private final String uuid;
    @Nullable
    private final UxTableOptions tableOptions;
    @Nullable
    private IcCubeRequestStatus requestStatus;

    protected UxRequestQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.uuid = uuid;
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        List requests;
        String fromPrintingJob;
        IcCubeRequestStatusManager manager = queryContext.getRequestStatusManager();
        this.requestStatus = manager.getRequestStatus(this.uuid);
        if (this.requestStatus == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.REQUEST_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        UxBabylonService babylon = queryContext.getUxBabylonService();
        boolean isForRestApi = queryContext.isForRestApi();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "uuid"), this.requestStatus.getRequestUUID()));
        IcCubeActiveRequestManager.GviInfo info = this.requestStatus.getGviInfo();
        if (info != null) {
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gviTimestamp"), String.valueOf(info.getTimestamp())));
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gviWindowUid"), info.getWindowUid()));
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "gviWidgetUid"), info.getWidgetUid() != null ? info.getWidgetUid() : "n/a"));
        }
        String progressInformation = this.requestStatus.getLocalizedProgressInformation(queryContext.getOlapBabylonService());
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "type"), this.requestStatus.getRequestUserFriendlyTypeName()));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "schema"), this.requestStatus.getSchemaEx()));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "user"), this.requestStatus.getUserName()));
        String printingJob = this.requestStatus.getPrintingJob();
        if (printingJob != null) {
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "printJob"), printingJob));
        }
        if ((fromPrintingJob = this.requestStatus.getFromPrintingJob()) != null) {
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "printJobFrom"), fromPrintingJob));
        }
        if ((requests = manager.getActiveDependentRequestStatus(printingJob)) != null) {
            for (IcCubeRequestStatus request : requests) {
                rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "printJobActiveRequest"), request.getRequestUUID() + " : " + request.getRequestUserFriendlyTypeName()));
            }
        }
        String localizedState = !isForRestApi ? this.requestStatus.getLocalizedState(queryContext.getOlapBabylonService()) : this.requestStatus.getState().name();
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "status"), localizedState).withStyle(UxRequestsQuery.getStyleLevel(this.requestStatus)));
        rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "progress"), progressInformation == null ? "" : progressInformation));
        rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "startTime"), this.requestStatus.getStartDateServerTimeForRequest()));
        Date completionDate = this.requestStatus.getCompletionDate();
        if (completionDate != null) {
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "endTime"), this.requestStatus.getCompletionDateServerTimeFoRequest()));
            rows.add(UxTableRow.create(babylon.translate_(isForRestApi, "duration"), CdTimeUtils.formatMillis((Locale)babylon.getLocale(), (long)this.requestStatus.getElapsedTimeMs())));
        }
        List details = this.requestStatus.getAllDetails(10);
        for (IcCubeRequestStatus.Detail detail : details) {
            rows.add(UxTableRow.createAsPreValue(detail.getName(), detail.getValue()));
        }
        List backupErrors = manager.getBackupErrors(this.requestStatus.getRequestUUID());
        if (!backupErrors.isEmpty()) {
            Object rawValue = "";
            for (CdError error : backupErrors) {
                rawValue = (String)rawValue + error.asMessage((CdBabylonService)queryContext.getOlapBabylonService()) + "\n";
            }
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "backupError"), (String)rawValue).withStyle(UxStyleLevel.ERROR));
        }
        List tableProcessingDetails = this.requestStatus.getTableProcessingDetails();
        for (IcCubeRequestStatus.Detail detail : tableProcessingDetails) {
            rows.add(UxTableRow.createAsPreValue(detail.getName(), detail.getValue()));
        }
        List errors = manager.getErrors(this.requestStatus.getRequestUUID());
        if (!errors.isEmpty()) {
            Object rawValue = "";
            for (CdError error : errors) {
                rawValue = (String)rawValue + error.asMessage((CdBabylonService)queryContext.getOlapBabylonService()) + "\n";
            }
            rows.add(UxTableRow.createAsPreValue(babylon.translate_(isForRestApi, "error"), (String)rawValue).withStyle(UxStyleLevel.ERROR));
        }
        UxTable table = UxTable.create(options, header, rows);
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxRequestQueryMeta.createUseCase(queryContext, this.uuid, this.requestStatus));
    }
}

