/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.request;

import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestState;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestProgressInfo;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestProgressInfoStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import java.util.List;

public class UxRequestProgressInfoQuery
extends UxAdminQuery {
    private final String uuid;

    protected UxRequestProgressInfoQuery(UxQueryMeta meta, OlapRequestId requestId, String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        IcCubeRequestStatusManager manager = queryContext.getRequestStatusManager();
        IcCubeRequestStatus requestStatus = manager.getRequestStatus(this.uuid);
        if (requestStatus == null) {
            return UxReply.actionSuccess(new UxRequestProgressInfo());
        }
        IcCubeRequestState state = requestStatus.getState();
        UxRequestProgressInfoStatus status = switch (state) {
            case IcCubeRequestState.CANCELLING -> UxRequestProgressInfoStatus.CANCELLING;
            case IcCubeRequestState.COMPLETED_ON_CANCELLED, IcCubeRequestState.COMPLETED_ON_ERROR, IcCubeRequestState.COMPLETED_ON_MDX_ERROR, IcCubeRequestState.COMPLETED -> UxRequestProgressInfoStatus.COMPLETED;
            default -> UxRequestProgressInfoStatus.ONGOING;
        };
        String phase = requestStatus.getPhase((CdBabylonService)queryContext.getUxBabylonService());
        List details = requestStatus.getPhaseDetails((CdBabylonService)queryContext.getUxBabylonService());
        return UxReply.actionSuccess(new UxRequestProgressInfo(status, phase, details));
    }
}

