/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.loggers.OlapLoggerLevel;
import crazydev.iccube.server.loggers.OlapLoggerLevelManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLoggersQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxSavedTableRow;
import crazydev.iccube.ux.common.table.UxTableRow;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class UxSaveLogLevelQuery
extends UxAdminQuery {
    private final String loggerName;
    private final String loggerLevel;

    protected UxSaveLogLevelQuery(UxQueryMeta meta, OlapRequestId requestId, String loggerName, String loggerLevel) {
        super(meta, requestId);
        this.loggerName = loggerName;
        this.loggerLevel = loggerLevel;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (CdStringUtils.isNullOrBlank((String)this.loggerName)) {
            return UxReply.actionSuccess();
        }
        Level level = UxSaveLogLevelQuery.level(this.loggerLevel);
        Logger logger = LogManager.getLogger((String)this.loggerName);
        OlapLoggerLevelManager manager = queryContext.getLoggerLevelManager();
        OlapLoggerLevelManager.LoggerLevel log = manager.overrideDefaultLevel(logger, level);
        UxTableRow row = UxLoggersQuery.createRow(queryContext.getUxBabylonService(), log);
        return UxReply.actionSuccess(new UxSavedTableRow(row.getCells()));
    }

    @Nullable
    private static Level level(@Nullable String name) {
        try {
            return OlapLoggerLevel.level(name);
        }
        catch (IllegalArgumentException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] unexpected error while retrieving the log level [" + name + "]"), (Throwable)ex);
            throw new UxQueryExpectedException(UxErrorCode.LOG_LEVEL_UNKNOWN, new Serializable[]{name});
        }
    }
}

