/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.loggers.OlapLoggerLevelManager;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxSaveLogLevelQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.filter.UxEnumFilterType;
import crazydev.iccube.ux.common.filter.UxFilterMeta;
import crazydev.iccube.ux.common.filter.UxFilterMetas;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableMeta;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableRowSearcher;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class UxLoggersQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxLoggersQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders header = new UxTableHeaders(new UxTableHeader("logger", babylon.translate("logger", new Serializable[0])), new UxTableHeader("level", babylon.translate("level", new Serializable[0]), UxLoggersQuery.levelMeta(babylon)), new UxTableHeader("description", babylon.translate("description", new Serializable[0])));
        UxFilterMetas filterMetas = new UxFilterMetas(new UxFilterMeta<OlapLoggerLevelManager.LoggerLevel>("logger", babylon.translate("filterLoggerName", new Serializable[0]), loggerLevel -> loggerLevel.name), new UxFilterMeta<OlapLoggerLevelManager.LoggerLevel>("level", babylon.translate("filterLoggerLevel", new Serializable[0]), UxEnumFilterType.create(babylon, Level.class), loggerLevel -> loggerLevel.hasOverriddenLevel ? loggerLevel.overriddenLevel : loggerLevel.defaultLevel));
        UxTableRowSearcher<OlapLoggerLevelManager.LoggerLevel> searcher = new UxTableRowSearcher<OlapLoggerLevelManager.LoggerLevel>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean isAccepting(OlapLoggerLevelManager.LoggerLevel row, String searchText) {
                return this.isContaining(searchText, row.name, row.hasOverriddenLevel ? row.overriddenLevel : row.defaultLevel);
            }
        };
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create("logger", UxTableSortType.asc));
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        OlapLoggerLevelManager manager = queryContext.getLoggerLevelManager();
        List<OlapLoggerLevelManager.LoggerLevel> loggers = this.filter(this.tableOptions, searcher, filterMetas, manager.getLoggerLevels());
        for (OlapLoggerLevelManager.LoggerLevel logger : loggers) {
            rows.add(UxLoggersQuery.createRow(babylon, logger));
        }
        UxTable table = UxTable.create(options, header, rows);
        UxAction saveAction = UxSaveLogLevelQueryMeta.createAction(queryContext);
        boolean editable = saveAction != null;
        UxTableMeta tableMeta = new UxTableMeta(searcher != null, filterMetas, saveAction);
        return UxReply.success(new UxTableReplyPayload(tableMeta, table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Loggers));
    }

    protected static UxTableRow createRow(UxBabylonService babylon, OlapLoggerLevelManager.LoggerLevel logger) {
        String name = logger.name;
        String overriddenLevel = logger.overriddenLevel;
        String defaultLevel = logger.defaultLevel;
        String description = UxLoggersQuery.loggerDescription(babylon, name);
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(new UxTableCell(name).withStyle(UxStylePresentation.PRE));
        cells.add(new UxTableCell((Object)overriddenLevel, defaultLevel));
        cells.add(new UxTableCell(description));
        return new UxTableRow(cells);
    }

    @Nullable
    private static String loggerDescription(UxBabylonService babylon, String name) {
        String description;
        String tag = name + ".description";
        if (tag.equals(description = babylon.translate(tag, new Serializable[0]))) {
            return null;
        }
        return description;
    }

    private static UxFieldMeta levelMeta(UxBabylonService babylon) {
        return new UxFieldMeta(UxFieldTypes.ENUM(babylon, Level.class), true, false, false);
    }
}

