/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.embedded.IcCubeEngineHelper;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLogFileQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxLogFilesQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxLogFilesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        try {
            UxBabylonService babylon = queryContext.getUxBabylonService();
            UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create("lastModified", UxTableSortType.desc));
            UxTableHeaders header = UxTableHeaders.create(babylon, "fileName", "size", "lastModified");
            ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
            List<LogFile> files = UxLogFilesQuery.getLogFiles(queryContext);
            for (LogFile file : files) {
                rows.add(UxLogFilesQuery.createRow(queryContext, file));
            }
            UxTable table = UxTable.create(options, header, rows);
            String useCaseAdditionalInfo = IcCubeEngineHelper.getLogDirectoryValue();
            return UxReply.success(new UxTableWithUseCasesReplyPayload(table, useCaseAdditionalInfo));
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] could not retrieve the log files", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.LOG_FILES_ERROR, (Serializable[])new Serializable[0]));
        }
    }

    private static UxTableRow createRow(UxQueryContext context, LogFile file) {
        UxBabylonService babylon = context.getUxBabylonService();
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxLogFileQueryMeta.createUseCase(context, file.path);
        cells.add(new UxTableCell((Object)file.path, useCase).withStyle(UxStylePresentation.PRE));
        cells.add(new UxTableCell(CdSizeUtils.formatEx((Locale)babylon.getLocale(), (double)file.size)).withStyle(UxStylePresentation.PRE).withValue_(file.size));
        cells.add(new UxTableCell(UxUtils.formatTimeServer(babylon, new Date(file.lastModified))).withValue_(file.lastModified));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.LogFiles));
    }

    private static List<LogFile> getLogFiles(UxQueryContext queryContext) throws IOException {
        List files;
        ArrayList<LogFile> paths = new ArrayList<LogFile>();
        OlapFileSystem fs = queryContext.getLogRoot();
        List list = files = fs == null ? null : fs.sortedList(1024, true);
        if (files != null) {
            for (OlapFile file : files) {
                if (file.isDirectory()) continue;
                String path = file.getPath();
                long size = file.length();
                long lastModified = file.lastModified();
                paths.add(new LogFile(path, size, lastModified));
            }
        }
        return paths;
    }

    static class LogFile {
        final String path;
        final long size;
        final long lastModified;

        public LogFile(String path, long size, long lastModified) {
            this.path = path;
            this.size = size;
            this.lastModified = lastModified;
        }
    }
}

