/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.ux.admin.queries.runtime.UxRuntimeQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxDownloadLogFileQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLogFileQuery;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLogFilesQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxLogFileQueryMeta
extends UxRuntimeQueryMeta {
    public static final UxLogFileQueryMeta LogFile = new UxLogFileQueryMeta();

    public UxLogFileQueryMeta() {
        super(UxConsoleConstants.QueryName.LogFile);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return UxLogFilesQueryMeta.LogFiles.isAuthorized(context);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) {
        String filePath = params.getStringParameter("path");
        return new UxLogFileQuery(this, params.getRequestId(), filePath);
    }

    public UxUrl createQueryUrl(String filePath) {
        return this.createQueryUrl().addParam("path", filePath);
    }

    static UxUseCase createUseCase(UxQueryContext context, @Nullable String filePath) {
        UxBabylonService babylon = context.getUxBabylonService();
        List<UxAction> actions = null;
        if (filePath != null) {
            actions = LogFile.createActions(context);
            actions.add(UxDownloadLogFileQueryMeta.createAction(context, filePath));
        }
        return new UxUseCaseBuilder(context, LogFile).withId(UxAdminUseCaseName.LogFile.name() + "-" + filePath).withCaption(babylon.translateUseCaseCaption(UxLogFileQueryMeta.LogFile.queryName.name(), new Serializable[0])).withUrl(LogFile.createQueryUrl(filePath)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.LogFiles), filePath, UxAdminUseCaseRepository.asBookmark(LogFile.createQueryUrl(filePath)))).withActions(actions).build(true);
    }

    @Nullable
    public static UxAction createNavigateToLatestLogFile(UxQueryContext context) {
        OlapFile file;
        String filePath = "icCube.log";
        OlapFileSystem logRoot = context.getLogRoot();
        OlapFile olapFile = file = logRoot == null ? null : logRoot.create("icCube.log");
        if (file == null || !file.exists()) {
            return null;
        }
        UxUseCase uc = UxLogFileQueryMeta.createUseCase(context, "icCube.log");
        if (uc == null) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate("navigateToLatestLogFile", new Serializable[0]);
        return new UxActionBuilder(context, LogFile).withUseCase(uc).withCaption(caption).build();
    }
}

