/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.logs;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdZipOptions;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UxDownloadLogFilesQuery
extends UxAdminQuery {
    protected UxDownloadLogFilesQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapFileSystem logRoot = queryContext.getLogRoot();
        OlapFile root = logRoot != null ? logRoot.create("") : null;
        try {
            OlapDirectoriesResolved directories = queryContext.getResolvedDirectories();
            CdVFileSystem vfs = directories.getVfs();
            File tmpDirectory = directories.getTmpDirectory();
            File zip = vfs.createTmpFileForDownload(tmpDirectory, "zip");
            vfs.zip(CdZipOptions.withoutRoot(), zip, new File[]{root != null ? root.__getUnderlying() : null});
            String mimeType = queryContext.getMimeTypeByExtension(zip.getName());
            OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)zip.getParentFile());
            OlapFile zip_ = fs.create(zip.getName());
            UxFileWrapper wrapper = UxFileWrapper.forOlapFile(zip_, zip.getName(), mimeType, true);
            String date = new SimpleDateFormat("dd_MMM_yyyy_HH_mm_ss").format(new Date());
            String attachmentName = "icCube.logs." + date + ".zip";
            return new UxAttachmentReply(wrapper, attachmentName);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] unexpected error while compressing the log files", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_IO_ERROR, (Serializable[])new Serializable[]{"icCube.logs", ex.getMessage()}));
        }
    }
}

