/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.cache;

import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.cache.OlapCacheManagerStats;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxPropertyTableReplyPayload;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxResultCacheQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;
    private final boolean download;

    protected UxResultCacheQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions, boolean download) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
        this.download = download;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create());
        UxTableHeaders header = UxTableHeaders.create(babylon, "property", "value");
        OlapCacheManager cacheManager = queryContext.getCacheManager();
        OlapCacheManagerStats stats = cacheManager.getStats();
        Map values = stats.getStats(babylon.getLocale());
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            rows.add(UxTableRow.createAsPreValue(key, value));
        }
        UxTable table = UxTable.create(!this.download ? options : null, header, rows);
        if (this.download) {
            return new UxAttachmentReply(table.asFileWrapper(queryContext), "ic3-result-cache.csv");
        }
        return UxReply.success(new UxPropertyTableReplyPayload(table));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.ResultCache));
    }
}

