/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.audit;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxAttachmentReply;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDownloadAuditFileQuery
extends UxAdminQuery {
    @Nullable
    private final String filePath;

    protected UxDownloadAuditFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String filePath) {
        super(meta, requestId);
        this.filePath = filePath;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapFile file = null;
        if (!CdStringUtils.isNullOrBlank((String)this.filePath)) {
            OlapDirectoriesResolved directories = queryContext.asRuntimeContext().getDirectoriesResolved();
            OlapFileSystem auditRoot = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)directories.getAuditDirectory());
            file = auditRoot.create(this.filePath);
        }
        if (file == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.FILE_NOT_FOUND, (Serializable[])new Serializable[]{this.filePath}));
        }
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(file, this.filePath, "text/plain", false);
        return new UxAttachmentReply(wrapper, null);
    }
}

