/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.runtime.audit;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.runtime.audit.UxAuditFileQueryMeta;
import crazydev.iccube.ux.admin.queries.utils.UxFileUtils;
import crazydev.iccube.ux.admin.queries.utils.UxFileWrapper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class UxAuditFileQuery
extends UxAdminQuery {
    @Nullable
    private final String filePath;
    @Nullable
    private OlapFile file;

    protected UxAuditFileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String filePath) {
        super(meta, requestId);
        this.filePath = filePath;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (!CdStringUtils.isNullOrBlank((String)this.filePath)) {
            OlapDirectoriesResolved directories = queryContext.asRuntimeContext().getDirectoriesResolved();
            OlapFileSystem auditRoot = OlapFileSystem.createFileSystem((CdVFileSystem)queryContext.getVfs(), (File)directories.getAuditDirectory());
            this.file = auditRoot.create(this.filePath);
        }
        String mimeType = "application/octet-stream";
        UxFileWrapper wrapper = UxFileWrapper.forOlapFile(this.file, this.filePath, "application/octet-stream", "audit", false);
        return UxFileUtils.createFileContent(queryContext, this.meta.queryName(), wrapper);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxAuditFileQueryMeta.createUseCase(queryContext, this.filePath));
    }
}

