/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.roles.UxAbstractRoleQuery;
import crazydev.iccube.ux.admin.queries.roles.UxRolesHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveRoleQuery
extends UxAbstractRoleQuery {
    @Nullable
    private final UxModel model;

    public UxSaveRoleQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxModel model) {
        super(meta, requestId);
        this.model = model;
    }

    @Override
    public boolean isForAllSchemas() {
        return true;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (this.model == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ROLE_MISSING_DEFINITION, (Serializable[])new Serializable[0]));
        }
        OlapRoleDefinition serverModel = (OlapRoleDefinition)queryContext.convertToServerModel(this.model);
        if (!queryContext.canEditOwnsRole(serverModel.getUUID())) {
            return UxReply.actionSuccess();
        }
        int revNumber = this.model.getRevNumber();
        UxValidationResult error = UxRolesHelper.saveRoleDefinition(queryContext, serverModel, revNumber);
        if (error != null) {
            return UxReply.validationErrors(error);
        }
        return UxReply.actionSuccess();
    }
}

