/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.roles.UxAbstractRoleQuery;
import crazydev.iccube.ux.admin.queries.roles.UxRoleQueryMeta;
import crazydev.iccube.ux.admin.queries.roles.UxSaveRoleQueryMeta;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.model.UxModelReplyPayload;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxRoleQuery
extends UxAbstractRoleQuery {
    @Nullable
    private final String uuid;
    @Nullable
    private OlapRoleDefinition role;

    public UxRoleQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ROLE_UNKNOWN, (Serializable[])new Serializable[]{""}));
        }
        IOlapPermissionsService service = queryContext.getRolePermissionsService();
        int revNumber = service.getRevisionNumber();
        this.role = service.getRoleDefinitionByUUID(this.uuid);
        if (this.role == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ROLE_UNKNOWN, (Serializable[])new Serializable[]{this.uuid}));
        }
        UxModel model = queryContext.convertToUxModel(revNumber, this.role);
        UxAction save = UxSaveRoleQueryMeta.createAction(queryContext, false, this.role.getUUID(), this.role.getName());
        return UxReply.success(new UxModelReplyPayload(model, save));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(UxRoleQueryMeta.createUseCase(queryContext, this.uuid, this.role != null ? this.role.getName() : null));
    }
}

