/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.roles;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.admin.queries.roles.UxAbstractRoleQuery;
import crazydev.iccube.ux.admin.queries.roles.UxRolesHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import org.jetbrains.annotations.Nullable;

public class UxDeleteRoleQuery
extends UxAbstractRoleQuery {
    @Nullable
    private final String uuid;

    public UxDeleteRoleQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String uuid) {
        super(meta, requestId);
        this.uuid = uuid;
    }

    @Override
    public boolean isForAllSchemas() {
        return true;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) {
        if (this.uuid == null || CdStringUtils.isNullOrBlank((String)this.uuid) || !queryContext.canEditOwnsRole(this.uuid)) {
            return UxReply.actionSuccess();
        }
        UxValidationResult error = UxRolesHelper.deleteRoleDefinition(queryContext, this.uuid);
        if (error != null) {
            return UxReply.validationErrors(error);
        }
        return UxReply.actionSuccess();
    }
}

