/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.restapi;

import com.google.gson.Gson;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.restapi.UxRestApiConsoleExecuteReplyPayload;
import crazydev.iccube.ux.common.json.UxJsonUtils;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxOlapBabylonService;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import crazydev.iccube.ux.processor.UxServerRequest;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.map.HashedMap;
import org.jetbrains.annotations.Nullable;

public class UxRestApiConsoleExecuteQuery
extends UxAdminQuery {
    private final String method;
    private final String url;
    private final String args;

    public UxRestApiConsoleExecuteQuery(UxQueryMeta meta, OlapRequestId requestId, String method, String url, @Nullable String args) {
        super(meta, requestId);
        this.method = method;
        this.url = url;
        this.args = args;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        try {
            return this.executeQueryUnsafe(queryContext);
        }
        catch (IOException | URISyntaxException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"UX request : unexpected REST API console, error", (Throwable)ex);
            return UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"UX request error : " + ex.getMessage()}));
        }
    }

    private UxReply executeQueryUnsafe(UxQueryContext queryContext) throws IOException, URISyntaxException {
        Map<String, String[]> restApiParameterMap = this.setupParameterMap(this.url);
        String restApiPathInfo = this.setupPathInfo(this.url);
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        UxRequestProcessor processor = appContext.getUxRequestProcessor();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)new HttpServletRequestHandler(queryContext, this.method, restApiPathInfo, restApiParameterMap, this.args));
        HttpServletResponse response = (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)new HttpServletResponseHandler(queryContext, out));
        try {
            OlapRequestType requestType = OlapRequestType.UX_API;
            OlapRequestId requestId = OlapRequestId.next((OlapRequestType)requestType);
            OlapRequestId.setThreadRequestId((OlapRequestId)requestId);
            processor.processUxRequest(UxApi.REST, request, response);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"UX request : unexpected error", (Throwable)ex);
            UxReply reply = UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"UX request error : " + ex.getMessage()}));
            reply.writeResponse(UxBabylonService.ENGLISH(UxApi.REST), request, response, UxApi.REST);
        }
        String payload = out.toString(StandardCharsets.UTF_8);
        Gson gson = UxJsonUtils.gson().create();
        Map json = (Map)gson.fromJson(payload, Map.class);
        return UxReply.success(new UxRestApiConsoleExecuteReplyPayload(json));
    }

    private String setupPathInfo(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String path = uri.getPath();
        return path;
    }

    private Map<String, String[]> setupParameterMap(String url) throws URISyntaxException, UnsupportedEncodingException {
        String[] pairs;
        URI uri = new URI(url);
        String query = uri.getQuery();
        HashedMap queryPairs = new HashedMap();
        for (String pair : pairs = CdStringUtils.isNotNullAndNotBlank((String)query) ? query.split("&") : new String[]{}) {
            String key;
            int idx = pair.indexOf("=");
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new ArrayList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)queryPairs.get(key)).add(value);
        }
        HashedMap queryPairsEx = new HashedMap();
        for (Map.Entry entry : queryPairs.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            queryPairsEx.put(key, values.toArray(new String[values.size()]));
        }
        return queryPairsEx;
    }

    static class HttpServletRequestHandler
    implements InvocationHandler {
        private final HttpServletRequest tunnellingRequest;
        private final Map<String, String[]> restApiParameterMap;
        private final String restApiMethod;
        private final String restApiPathInfo;
        private final String restApiArgs;

        public HttpServletRequestHandler(UxQueryContext context, String method, String pathInfo, Map<String, String[]> parameterMap, @Nullable String args) {
            UxServerRequestContext serverContext = context.asServerRequestContext();
            UxServerRequest request = (UxServerRequest)((Object)serverContext.getRequest());
            this.tunnellingRequest = request.getHttpRequest();
            this.restApiParameterMap = parameterMap;
            this.restApiMethod = method;
            this.restApiPathInfo = pathInfo;
            this.restApiArgs = args;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("setCharacterEncoding")) {
                return null;
            }
            if (method.getName().equals("getParameterMap")) {
                return this.restApiParameterMap;
            }
            if (method.getName().equals("getMethod")) {
                return this.restApiMethod;
            }
            if (method.getName().equals("getContentType")) {
                return "application/json";
            }
            if (method.getName().equals("getReader")) {
                return new BufferedReader(new StringReader(this.restApiArgs != null ? this.restApiArgs : ""));
            }
            if (method.getName().equals("getSession")) {
                return this.tunnellingRequest.getSession(false);
            }
            if (method.getName().equals("getPathInfo")) {
                return this.restApiPathInfo;
            }
            if (method.getName().equals("getCookies")) {
                return this.tunnellingRequest.getCookies();
            }
            if (method.getName().equals("getHeader")) {
                String header = (String)args[0];
                if ("X-CONSOLE".equals(header)) {
                    return "ic3";
                }
                return this.tunnellingRequest.getHeader(header);
            }
            if (method.getName().equals("toString")) {
                return this.restApiPathInfo;
            }
            throw new RuntimeException("internal error: HttpServletRequest." + method.getName() + " not supported");
        }
    }

    static class HttpServletResponseHandler
    implements InvocationHandler {
        private final UxQueryContext context;
        private final ByteArrayOutputStream out;
        private final ServletOutputStream sOut;

        public HttpServletResponseHandler(UxQueryContext context, final ByteArrayOutputStream out) {
            this.context = context;
            this.out = out;
            this.sOut = new ServletOutputStream(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean isReady() {
                    return false;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) throws IOException {
                    out.write(b);
                }
            };
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("setContentType")) {
                return null;
            }
            if (method.getName().equals("getOutputStream")) {
                return this.sOut;
            }
            if (method.getName().equals("toString")) {
                return this.out.toString(StandardCharsets.UTF_8);
            }
            throw new RuntimeException("internal error: HttpServletResponse." + method.getName() + " not supported");
        }
    }
}

