/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.reporting.printing;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoDefinition;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmoEntityType;
import crazydev.iccube.gwt.server.reporting.repository.gizmos.OlapDocsGizmosRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.gvi.request.report.GviPrintParams;
import crazydev.iccube.server.print.IcCubePrintComponentConfiguration;
import crazydev.iccube.server.request.processor.print.IcCubePrintJobResult;
import crazydev.iccube.server.request.processor.print.IcCubePrintReportBatchJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintService;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSize;
import crazydev.iccube.server.request.processor.print.paper.IcCubePaperSizes;
import crazydev.iccube.ux.admin.queries.reporting.printing.UxReportingPrintReportQueryMeta;
import crazydev.iccube.ux.admin.queries.reporting.printing.UxReportingPrintReportResult;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import java.util.HashMap;

public class UxReportingPrintReportQuery
extends UxQuery {
    private final String reportPath;
    private final boolean withPDF;
    private final String pageSize;
    private final String pageOrientation;
    private final int timeoutS;

    public UxReportingPrintReportQuery(UxReportingPrintReportQueryMeta meta, OlapRequestId requestId, String reportPath, boolean withPDF, String pageSize, String pageOrientation, int timeoutS) {
        super(meta, requestId);
        this.reportPath = reportPath;
        this.withPDF = withPDF;
        this.pageSize = pageSize;
        this.pageOrientation = pageOrientation;
        this.timeoutS = timeoutS;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        IcCubePrintService printService = appContext.getPrintService();
        if (printService == null || !printService.isPrintOnServerAvailable()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PRINT_SERVICE_MISSING, (Serializable[])new Serializable[0]));
        }
        if (this.isReportMissing(queryContext)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PRINT_REPORT_MISSING, (Serializable[])new Serializable[]{this.reportPath}));
        }
        try {
            IcCubeRequestStatusManager requests = queryContext.getRequestStatusManager();
            OlapBabylonService babylon = queryContext.getOlapBabylonService();
            IcCubePrintReportBatchJob printJob = this.setupPrintJob(queryContext, printService);
            IcCubePrintJobResult printResult = printService.execute(babylon, requests, printJob);
            if (printResult.isInError()) {
                String error = printResult.getError();
                return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PRINT_REPORT_ERROR, (Serializable[])new Serializable[]{error != null ? error : "n/a"}));
            }
            if (this.withPDF) {
                return UxReply.actionSuccess(new UxReportingPrintReportResult(true, printResult.getAttachmentName(), printResult.getAttachmentContentEx()));
            }
            return UxReply.actionSuccess(new UxReportingPrintReportResult(true));
        }
        catch (InterruptedException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] could not print the report", (Throwable)ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.PRINT_REPORT_UNEXPECTED_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
    }

    private boolean isReportMissing(UxQueryContext context) {
        try {
            IcCubeServerApplicationContext appContext = context.getApplicationContext();
            OlapEngineRequestContext oContext = context.getOlapEngineRequestContext();
            OlapEngineApplicationContext oAppContext = oContext.getApplicationContext();
            OlapPrincipal principal = context.getSessionContext().getUser();
            OlapReportRepositoryRequestContext repositoryContext = new OlapReportRepositoryRequestContext(context.asServerRequestContext(), null, true);
            OlapRuntimeContext rContext = OlapRuntimeContext.create((OlapEngineApplicationContext)oAppContext, (OlapTenant)principal.getTenant());
            OlapDocsActualRepository docs = appContext.getDocsRepository(rContext);
            OlapPath namePath = docs.fromLogicalSimplePath(repositoryContext, this.reportPath);
            OlapDocsGizmosRepository gizmos = docs.asGizmosRepository(OlapDocsGizmoEntityType.DASHBOARD);
            OlapDocsGizmoDefinition ignored = gizmos.getGizmo(repositoryContext, namePath);
            return false;
        }
        catch (Exception ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] report not found [" + this.reportPath + "]"), (Throwable)ex);
            return true;
        }
    }

    private IcCubePrintReportBatchJob setupPrintJob(UxQueryContext context, IcCubePrintService printService) {
        IcCubePaperSize paperSize;
        String requestUUID = this.requestId.getClientUUID();
        IcCubePrintComponentConfiguration configuration = printService.getConfiguration();
        IcCubePaperSizes paperSizes = configuration.getPaperSizes();
        IcCubePaperSize icCubePaperSize = paperSize = paperSizes != null ? paperSizes.getPaperSize(this.pageSize) : null;
        if (paperSize == null) {
            OlapLoggers.PRINT.error((Object)("configuration error: missing paper size [" + this.pageSize + "]"));
            throw new RuntimeException("configuration error: missing paper size [" + this.pageSize + "]");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        GviPrintParams printParams = new GviPrintParams("-", "dft", "-", this.reportPath, null, null, this.timeoutS, null, 1.0, paperSize.getUnit(), "landscape".equals(this.pageOrientation) ? paperSize.getHeightEx() : paperSize.getWidthEx(), "landscape".equals(this.pageOrientation) ? paperSize.getWidthEx() : paperSize.getHeightEx(), 0.0, 0.0, 0.0, 0.0, null, options);
        return new IcCubePrintReportBatchJob(printService, requestUUID != null ? requestUUID : "n/a", context.getSessionContext().getUser(), printParams, null);
    }
}

