/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.reporting;

import com.vdurmont.semver4j.Semver;
import crazydev.common.babylon.CdBabylonService;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingComponentConfiguration;
import crazydev.iccube.gwt.server.reporting.component.OlapReportingLocation;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsError;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorCode;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsDashboardsVersion;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.gwt.server.requesthandler.reporting.OlapReportRepositoryRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.runtime.OlapRuntimeDashboardsVersion;
import crazydev.iccube.server.configuration.IcCubeServerConfiguration;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingVersionInfo;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxFileUploadReply;
import crazydev.iccube.ux.common.reply.UxMessageReplyPayload;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class UxReportingHelper {
    private UxReportingHelper() {
    }

    public static UxFileUploadReply installDashboards(UxQueryContext context, UxServerRequestParams params, String filename, InputStream in) throws IOException {
        try {
            boolean withBackup = params.getBooleanParameter("backup");
            OlapDocsActualRepository repository = (OlapDocsActualRepository)context.getDocsRepository(UxDocsRepositoryType.WEB_DOCS);
            IOlapDocsRequestContext docsContext = context.createDocsRequestContext(null, true);
            repository.installWebDashboards(docsContext, filename, in, withBackup);
            return UxFileUploadReply.success();
        }
        catch (OlapDocsErrorException | UxQueryParserException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] reporting app. installation error", (Throwable)ex);
            return UxFileUploadReply.error(ex.getError().asMessage((CdBabylonService)context.getOlapBabylonService()));
        }
    }

    public static UxReply installDashboardsFromKit(UxQueryContext context) {
        IcCubeServerApplicationContext appContext = context.getApplicationContext();
        OlapRuntime runtime = appContext.getRuntime();
        File file = runtime.getWebDashboardsKit();
        if (file == null || !file.isFile()) {
            return UxReply.success(new UxMessageReplyPayload(new OlapDocsError(OlapDocsErrorCode.REPORT_WEB_DASHBOARDS_KIT_MISSING, new Serializable[0]).asMessage((CdBabylonService)context.getOlapBabylonService())));
        }
        try {
            OlapDocsActualRepository repository = (OlapDocsActualRepository)context.getDocsRepository(UxDocsRepositoryType.WEB_DOCS);
            IOlapDocsRequestContext docsContext = context.createDocsRequestContext(null, true);
            repository.installWebDashboardsFromKit(docsContext, file);
            return UxReply.actionSuccess();
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] dashboards app. installation error", (Throwable)((Object)ex));
            return UxReply.error(context, ex.getError());
        }
    }

    public static UxReply restoreDashboardsTo(UxQueryContext context, String timestamp) {
        OlapDocsActualRepository repository = (OlapDocsActualRepository)context.getDocsRepository(UxDocsRepositoryType.WEB_DOCS);
        IOlapDocsRequestContext docsContext = context.createDocsRequestContext(null, true);
        try {
            repository.restoreWebDashboards(docsContext, timestamp);
            return UxReply.actionSuccess();
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] dashboards app. restore error", (Throwable)((Object)ex));
            return UxReply.error(context, ex.getError());
        }
    }

    public static UxReply deleteAllDashboardsBackups(UxQueryContext context) {
        OlapDocsActualRepository repository = (OlapDocsActualRepository)context.getDocsRepository(UxDocsRepositoryType.WEB_DOCS);
        IOlapDocsRequestContext docsContext = context.createDocsRequestContext(null, true);
        try {
            repository.deleteAllWebDashboardsBackups(docsContext);
            return UxReply.actionSuccess();
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] dashboards app. delete all backups error", (Throwable)((Object)ex));
            return UxReply.error(context, ex.getError());
        }
    }

    public static UxReply deleteDashboards(UxQueryContext context, boolean active, @Nullable String timestamp) {
        OlapDocsActualRepository repository = (OlapDocsActualRepository)context.getDocsRepository(UxDocsRepositoryType.WEB_DOCS);
        IOlapDocsRequestContext docsContext = context.createDocsRequestContext(null, true);
        try {
            repository.deleteWebDashboards(docsContext, active, timestamp);
            return UxReply.actionSuccess();
        }
        catch (OlapDocsErrorException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] dashboards app. delete error", (Throwable)((Object)ex));
            return UxReply.error(context, ex.getError());
        }
    }

    public static boolean isReportingInDocs(UxQueryContext context) {
        IcCubeServerApplicationContext appContext = context.getApplicationContext();
        IcCubeServerConfiguration configuration = appContext.getConfiguration();
        OlapReportingComponentConfiguration reportingConfiguration = configuration.getReportingConfiguration();
        OlapReportingLocation reportingLocation = reportingConfiguration != null ? reportingConfiguration.getLocation() : null;
        return reportingLocation == OlapReportingLocation.DOCS;
    }

    @Nullable
    public static UxReportingVersionInfo availableDashboardsVersion(UxQueryContext context) {
        OlapReportRepositoryRequestContext repReqCtxt;
        if (!UxReportingHelper.isReportingInDocs(context)) {
            return null;
        }
        OlapDocsActualRepository repository = context.getDocsRepository();
        OlapDocsDashboardsVersion installedVersion = repository.getInstalledDashboardsVersion(repReqCtxt = context.createRepositoryContext(true));
        OlapLoggers.DOC_REPOSITORY.info((Object)("[dashboards] installed version [" + String.valueOf(installedVersion != null ? installedVersion.version : "<null>") + "]"));
        IcCubeServerApplicationContext appContext = context.getApplicationContext();
        OlapRuntime runtime = appContext.getRuntime();
        OlapRuntimeDashboardsVersion kitVersion = runtime.getWebDashboardsVersion();
        OlapLoggers.DOC_REPOSITORY.info((Object)("[dashboards] kit version [" + String.valueOf(kitVersion != null ? kitVersion : "<null>") + "]"));
        if (kitVersion == null) {
            return null;
        }
        if (installedVersion == null) {
            return new UxReportingVersionInfo(kitVersion.getVersionWithTimestamp(), "n/a", true);
        }
        Semver installedVersion_ = installedVersion.version;
        Semver kitVersion_ = new Semver(kitVersion.version, Semver.SemverType.LOOSE);
        boolean isNewer = kitVersion_.isGreaterThan(installedVersion_);
        return new UxReportingVersionInfo(kitVersion.getVersionWithTimestamp(), installedVersion.getVersionWithTimestamp(), isNewer);
    }
}

