/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.plugins;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.plugins.OlapEngineAllPluginsInfo;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.plugins.UxPluginQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTable;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.common.table.UxTableWithUseCasesReplyPayload;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxPluginsQuery
extends UxAdminQuery {
    @Nullable
    private final UxTableOptions tableOptions;

    protected UxPluginsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxTableOptions tableOptions) {
        super(meta, requestId);
        this.tableOptions = tableOptions;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableOptions options = UxTableOptions.extendWithMissings(this.tableOptions, UxTableOptions.create("name", UxTableSortType.asc));
        UxTableHeaders header = UxTableHeaders.create(babylon, "name", "status");
        ArrayList<UxTableRow> rows = new ArrayList<UxTableRow>();
        OlapEngineComponent engine = queryContext.getOlapEngineComponent();
        OlapEngineAllPluginsInfo plugins = engine.getAllPluginsInfo();
        List locations = plugins.getAllPluginLocations();
        for (File location : locations) {
            String pluginName = plugins.getPluginName(location);
            if (pluginName == null) continue;
            String status = plugins.hasErrors(location) ? babylon.translate("invalid", new Serializable[0]) : babylon.translate("loaded", new Serializable[0]);
            rows.add(UxPluginsQuery.createRow(queryContext, pluginName, status));
        }
        UxTable table = UxTable.create(options, header, rows);
        File pluginsDirectory = queryContext.getPluginsDirectory();
        String useCaseAdditionalInfo = pluginsDirectory.getAbsolutePath();
        return UxReply.success(new UxTableWithUseCasesReplyPayload(table, useCaseAdditionalInfo));
    }

    private static UxTableRow createRow(UxQueryContext context, String pluginName, String status) {
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        UxUseCase useCase = UxPluginQueryMeta.createUseCase(context, pluginName);
        cells.add(new UxTableCell((Object)pluginName, useCase));
        cells.add(new UxTableCell(status));
        return new UxTableRow(cells);
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Plugins));
    }
}

