/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.init;

import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.util.OlapOOM;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.bigbrother.counters.cpu.IcBigBrotherSunMxSystemCputimeCounter;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.UxAdminQuery;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertsQueryMeta;
import crazydev.iccube.ux.admin.queries.dashboards.UxDashboardsInstallVersionQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxDownloadLogFilesQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLogFileQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.request.UxRequestsQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.sessions.UxSessionsQueryMeta;
import crazydev.iccube.ux.admin.queries.runtime.status.UxServerStatusQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxLoadedSchemasQueryMeta;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionUtils;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxHomeEntry;
import crazydev.iccube.ux.common.reply.UxHomeReplyPayload;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.console.queries.upload.UxUploadFileQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxAdminHomeQuery
extends UxAdminQuery {
    @Nullable
    private static final IcBigBrotherSunMxSystemCputimeCounter CPU_LOAD;

    protected UxAdminHomeQuery(UxQueryMeta meta, OlapRequestId requestId) {
        super(meta, requestId);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        ArrayList<UxHomeEntry> entries = new ArrayList<UxHomeEntry>();
        this.setupLoadedSchemas(queryContext, entries);
        this.setupActiveRequests(queryContext, entries);
        this.setupActiveSessions(queryContext, entries);
        this.setupActiveAlerts(queryContext, entries);
        this.setupMemoryUsed(queryContext, entries);
        this.setupCpuLoad(queryContext, entries);
        UxAction mdxQueries = UxRequestsQueryMeta.createMdxQueries(queryContext);
        UxAction navigateToLatestLogFile = UxLogFileQueryMeta.createNavigateToLatestLogFile(queryContext);
        UxAction downloadLogfiles = UxDownloadLogFilesQueryMeta.createAction(queryContext);
        UxAction refreshDashboardApp = UxDashboardsInstallVersionQueryMeta.createActionIfNewer(queryContext);
        UxAction uploadDashboardApp = UxUploadFileQueryMeta.createActionForDashboardsInstall(queryContext);
        List<UxAction> favorites = UxActionUtils.addActions(null, mdxQueries, navigateToLatestLogFile, downloadLogfiles, uploadDashboardApp, refreshDashboardApp);
        String favoritesLabel = queryContext.getUxBabylonService().translate("Shortcuts", new Serializable[0]);
        return UxReply.success(new UxHomeReplyPayload(UxAppType.admin, entries, favorites, favoritesLabel));
    }

    private void setupLoadedSchemas(UxQueryContext context, List<UxHomeEntry> entries) {
        OlapRuntimeContext rContext = context.asRuntimeContext();
        UxAction action = UxLoadedSchemasQueryMeta.createAction(context);
        if (action == null) {
            return;
        }
        OlapEngineComponent engine = context.getOlapEngineComponent();
        int count = engine.getLoadedSchemaCount(rContext);
        double ram = engine.getLoadedSchemaMemory(rContext);
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeLoadedSchemas", new Serializable[0]);
        String message = "" + count;
        String[] memory = CdSizeUtils.formatEx_((Locale)babylon.getLocale(), (double)ram);
        entries.add(new UxHomeEntry(title, message, null, memory[0], memory[1], -1, action));
    }

    private void setupActiveRequests(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = UxRequestsQueryMeta.createActiveQueries(context);
        if (action == null) {
            return;
        }
        String myself = this.getRequestId().getClientUUID();
        IcCubeRequestStatusManager requests = context.getRequestStatusManager();
        int count = requests.getActiveRequestCount(myself);
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeActiveRequests", new Serializable[0]);
        String message = "" + count;
        entries.add(new UxHomeEntry(title, message, action));
    }

    private void setupActiveSessions(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = UxSessionsQueryMeta.createAction(context);
        if (action == null) {
            return;
        }
        IcCubeServerApplicationContext appContext = context.getApplicationContext();
        OlapCacheManager cacheManager = appContext.getCacheManager();
        int count = cacheManager.getSessionCount();
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeActiveSessions", new Serializable[0]);
        String message = "" + count;
        entries.add(new UxHomeEntry(title, message, action));
    }

    private void setupActiveAlerts(UxQueryContext context, List<UxHomeEntry> entries) {
        UxAction action = UxAlertsQueryMeta.createAction(context);
        if (action == null) {
            return;
        }
        IcCubeScheduler scheduler = context.getScheduler(IcCubeSchedulerKind.ALERTS);
        int count = scheduler.getActiveJobCount(context.asRuntimeContext());
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeActiveAlerts", new Serializable[0]);
        String message = "" + count;
        entries.add(new UxHomeEntry(title, message, action));
    }

    private void setupMemoryUsed(UxQueryContext context, List<UxHomeEntry> entries) {
        long free;
        UxAction action = UxServerStatusQueryMeta.createAction(context);
        if (action == null) {
            return;
        }
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - (free = Runtime.getRuntime().freeMemory());
        double percent = (double)used * 100.0 / (double)max;
        Object percent_ = percent < 1.0 ? "<1" : "" + (int)percent;
        UxBabylonService babylon = context.getUxBabylonService();
        boolean oom = OlapOOM.oom;
        String title = babylon.translate("homeMemoryUsed", new Serializable[]{oom ? " [out-of-memory]" : ""});
        String[] message = CdSizeUtils.formatEx_((Locale)babylon.getLocale(), (double)used);
        int color = 0;
        if (oom) {
            color = 4;
        } else if (percent >= 90.0) {
            color = 4;
        } else if (percent >= 80.0) {
            color = 3;
        } else if (percent >= 70.0) {
            color = 2;
        } else if (percent >= 60.0) {
            color = 1;
        }
        entries.add(new UxHomeEntry(title, message[0], message[1], (String)percent_, "%", color, action));
    }

    private void setupCpuLoad(UxQueryContext context, List<UxHomeEntry> entries) {
        if (CPU_LOAD == null) {
            return;
        }
        UxAction action = UxServerStatusQueryMeta.createAction(context);
        if (action == null) {
            return;
        }
        double percent = CPU_LOAD.collect() * 100.0;
        Object percent_ = percent < 1.0 ? "<1" : "" + (int)percent;
        UxBabylonService babylon = context.getUxBabylonService();
        String title = babylon.translate("homeCpuLoad", new Serializable[0]);
        int color = 0;
        if (percent >= 90.0) {
            color = 4;
        } else if (percent >= 80.0) {
            color = 3;
        } else if (percent >= 70.0) {
            color = 2;
        } else if (percent >= 60.0) {
            color = 1;
        }
        entries.add(new UxHomeEntry(title, (String)percent_, "%", color, action));
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.AdminHome));
    }

    static {
        IcBigBrotherSunMxSystemCputimeCounter counter = null;
        try {
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            counter = IcBigBrotherSunMxSystemCputimeCounter.instance(osBean);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        CPU_LOAD = counter;
    }
}

