/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.queries.docs.UxDocsSharingsQuery;
import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBreadcrumb;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.queries.refresh.UxRefreshQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsSharingsQueryMeta
extends UxAbstractDocsQueryMeta {
    public static final UxDocsSharingsQueryMeta DocsSharings = new UxDocsSharingsQueryMeta();

    protected UxDocsSharingsQueryMeta() {
        super(UxConsoleConstants.QueryName.DocsSharings);
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        return UxArrays.asList(UxRefreshQueryMeta.createAction(context));
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        UxDocsRepositoryType repositoryType = params.getEnumParameter(UxDocsRepositoryType.class, "repo");
        UxDocsEntryPath path = params.getPathParameter("path");
        return new UxDocsSharingsQuery(this, params.getRequestId(), repositoryType, path);
    }

    public UxUrl createQueryUrl(UxDocsRepositoryType repositoryType, UxDocsEntryPath path) {
        return this.createQueryUrl().addParam("repo", repositoryType.name()).addParam("path", path);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context, UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        UxUseCase useCase = UxDocsSharingsQueryMeta.createUseCase(context, repositoryType, path);
        return new UxActionBuilder(context, DocsSharings).withUseCase(useCase).build();
    }

    public static UxUseCase createUseCase(UxQueryContext context, UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String info = babylon.translate("docsDocsPermissions", new Serializable[]{path.toString()});
        UxUseCaseBreadcrumb breadcrumb = UxDocsSharingsQueryMeta.setupUseCaseBreadcrumb(context, repositoryType, path);
        return new UxUseCaseBuilder(context, DocsSharings).withId(UxAdminUseCaseName.DocsSharings).withUrl(DocsSharings.createQueryUrl(repositoryType, path)).withExtraTitle(new UxUseCaseTitle(context.getUseCase(UxAdminUseCaseName.Docs), info, UxAdminUseCaseRepository.asBookmark(DocsSharings.createQueryUrl(repositoryType, path)), breadcrumb)).build(true);
    }
}

