/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.mdx.parser.MdxParser;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxDocsPermsExpression;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxDocsSaveSharingsQuery
extends UxAbstractDocsQuery {
    private final UxDocsRepositoryType repositoryType;
    private final UxDocsEntryPath path;
    @Nullable
    private final String content;

    public UxDocsSaveSharingsQuery(UxQueryMeta meta, OlapRequestId requestId, UxDocsRepositoryType repositoryType, UxDocsEntryPath path, @Nullable String content) {
        super(meta, requestId);
        this.repositoryType = repositoryType;
        this.path = path;
        this.content = content;
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) throws OlapDocsErrorException {
        if (this.path == null || this.path.isEmpty()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"path = <null> or <empty>"}));
        }
        try {
            @Nullable MdxDocsPermsExpression perms = this.validateProfile(queryContext);
            OlapPath absPath = UxDocsSaveSharingsQuery.setupOlapPath(this.path);
            Object repository = queryContext.getDocsRepository(this.repositoryType);
            IOlapDocsRequestContext docsContext = queryContext.createDocsRequestContext();
            ((OlapDocsRepository)repository).saveOrUpdateEntityPermissions(docsContext, absPath, perms);
            return UxReply.actionSuccess();
        }
        catch (CdMdxScannerException | MdxParserException ex) {
            CdErrorLocation location = ex.getLocation();
            int lineNumber = location != null ? location.lineNumber() : -1;
            OlapLoggers.UX_REQUEST.error((Object)("[UX] docs perms: invalid definition [line:" + lineNumber + "]"), ex);
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.DOCS_PERMS_ERROR, (Serializable[])new Serializable[]{Integer.valueOf(lineNumber), ex.getMessage()}));
        }
    }

    private MdxDocsPermsExpression validateProfile(UxQueryContext context) throws CdMdxScannerException, MdxParserException {
        OlapEngineRequestContext eContext = context.getOlapEngineRequestContext();
        OlapEngineComponent engine = eContext.getOlapEngineComponent();
        OlapProperties properties = eContext.getOlapEngineProperties();
        OlapFunctionRepository functionRepository = engine.getFunctionRepository();
        OlapSchemaFunctionRepository schemaFunctionRepository = new OlapSchemaFunctionRepository(functionRepository);
        OlapIntrinsicMemberPropertyManager memberPropertyManager = new OlapIntrinsicMemberPropertyManager(true);
        MdxParsingContext parsingContext = new MdxParsingContext(properties, functionRepository, schemaFunctionRepository.createSnapshot(), memberPropertyManager, true);
        MdxDocsPermsExpression perms = MdxParser.parseDocsPerms((MdxParsingContext)parsingContext, (String)(CdStringUtils.isNotNullAndNotBlank((String)this.content) ? this.content : ""), (String)"docs-perms-no-hash");
        return perms;
    }
}

