/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.admin.queries.docs;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.gwt.server.reporting.errors.OlapDocsErrorException;
import crazydev.iccube.gwt.server.reporting.model.OlapDocsEntity;
import crazydev.iccube.gwt.server.reporting.repository.IOlapDocsRequestContext;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsRepository;
import crazydev.iccube.gwt.server.reporting.repository.webpub.OlapDocsFileSystemRepository;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.docs.UxAbstractDocsQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsDetailsQuery;
import crazydev.iccube.ux.admin.queries.docs.UxDocsDetailsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntry;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryList;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryType;
import crazydev.iccube.ux.admin.queries.docs.UxDocsReplyPayload;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepository;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxDocsQuery
extends UxAbstractDocsQuery {
    private final boolean noListing;
    private final UxDocsRepositoryType repositoryType;
    @Nullable
    private final UxDocsEntryPath path;
    private final OlapPath absPath;

    public UxDocsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxDocsRepositoryType repositoryType, @Nullable UxDocsEntryPath path) {
        super(meta, requestId);
        this.noListing = repositoryType == null && (path == null || path.isEmpty());
        this.repositoryType = repositoryType != null ? repositoryType : UxDocsRepositoryType.WEB_DOCS;
        this.path = path;
        this.absPath = UxDocsQuery.setupOlapPath(path);
    }

    @Override
    protected UxReply doExecuteQuery(UxQueryContext queryContext) throws OlapDocsErrorException {
        List<UxDocsRepository> repositories = this.setupRepositories(queryContext);
        UxDocsEntryList listing = this.list(queryContext);
        List<UxAction> actions = this.actions(queryContext);
        return UxReply.success(new UxDocsReplyPayload(repositories, this.repositoryType, listing, actions));
    }

    private List<UxDocsRepository> setupRepositories(UxQueryContext context) {
        ArrayList<UxDocsRepository> repositories = new ArrayList<UxDocsRepository>();
        UxDocsRepository fsRepository = this.setupFileSystemRootRepository(context);
        if (fsRepository != null) {
            repositories.add(fsRepository);
        }
        repositories.add(this.setupWebPubRepository(context));
        repositories.add(this.setupDocsRepository(context));
        return repositories;
    }

    @Nullable
    private UxDocsRepository setupFileSystemRootRepository(UxQueryContext context) {
        UxDocsRepositoryType type = UxDocsRepositoryType.FILE_SYSTEM_ROOT;
        UxBabylonService babylon = context.getUxBabylonService();
        if (!context.isAdministrator() && !context.isDocAdministrator()) {
            return null;
        }
        OlapDocsFileSystemRepository repository = (OlapDocsFileSystemRepository)context.getDocsRepository(type);
        String caption = babylon.translate("docsFileSystem", new Serializable[0]);
        String description = babylon.translate("docsFileSystemTooltip", new Serializable[0]);
        List<UxAction> actions = this.setupActions(context, type);
        UxAction actionDetails = UxDocsDetailsQueryMeta.createAction(context, type);
        return new UxDocsRepository(type, repository.isEnabled() && context.isAdministrator(), caption, description, actions, actionDetails);
    }

    private UxDocsRepository setupWebPubRepository(UxQueryContext context) {
        UxDocsRepositoryType type = UxDocsRepositoryType.WEB_PUBLIC;
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate("docsWebPub", new Serializable[0]);
        String description = babylon.translate("docsWebPubTooltip", new Serializable[0]);
        List<UxAction> actions = this.setupActions(context, type);
        UxAction actionDetails = UxDocsDetailsQueryMeta.createAction(context, type);
        return new UxDocsRepository(type, true, caption, description, actions, actionDetails);
    }

    private UxDocsRepository setupDocsRepository(UxQueryContext context) {
        UxDocsRepositoryType type = UxDocsRepositoryType.WEB_DOCS;
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate("docsDocs", new Serializable[0]);
        String description = babylon.translate("docsDocsTooltip", new Serializable[0]);
        List<UxAction> actions = this.setupActions(context, type);
        UxAction actionDetails = UxDocsDetailsQueryMeta.createAction(context, type);
        return new UxDocsRepository(type, true, caption, description, actions, actionDetails);
    }

    @Nullable
    private List<UxAction> setupActions(UxQueryContext context, UxDocsRepositoryType type) {
        return null;
    }

    private UxDocsEntryList list(UxQueryContext queryContext) throws OlapDocsErrorException {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        UxTableHeaders tableHeader = UxTableHeaders.create(babylon, "name");
        Object repository = queryContext.getDocsRepository(this.repositoryType);
        OlapPath absPath = UxDocsQuery.setupOlapPath(this.path);
        IOlapDocsRequestContext docsContext = queryContext.createDocsRequestContext();
        UxTableOptions tableOptions = null;
        List<Object> entities = new ArrayList();
        if (!this.noListing) {
            entities = ((OlapDocsRepository)repository).getEntities(docsContext, absPath);
        }
        ArrayList<UxDocsEntry> entries = new ArrayList<UxDocsEntry>();
        for (OlapDocsEntity olapDocsEntity : entities) {
            Date lastModified = olapDocsEntity.getLastModified();
            String lastModifiedS = lastModified != null ? CdTimeUtils.formatServerTimeForRequest((Date)lastModified) : null;
            String permissions = UxDocsQuery.setupPermissionsTooltip(queryContext.getUxBabylonService(), repository, docsContext, olapDocsEntity);
            entries.add(new UxDocsEntry(olapDocsEntity.isLabel() ? UxDocsEntryType.FOLDER : UxDocsEntryType.FILE, olapDocsEntity.getCaption(), lastModifiedS, lastModified != null ? lastModified.getTime() : 0L, permissions));
        }
        return new UxDocsEntryList(tableOptions, tableHeader, UxDocsEntryPath.fromOlapPath(absPath), entries);
    }

    private List<UxAction> actions(UxQueryContext queryContext) throws OlapDocsErrorException {
        Object repository = queryContext.getDocsRepository(this.repositoryType);
        IOlapDocsRequestContext docsContext = queryContext.createDocsRequestContext();
        OlapDocsEntity entity = ((OlapDocsRepository)repository).getEntity(docsContext, this.absPath, false);
        List<UxAction> actions = UxDocsDetailsQuery.setupActions(queryContext, this.repositoryType, repository, this.absPath, entity);
        return actions;
    }

    @Override
    protected void attachUseCase(UxQueryContext queryContext, UxPayloadReply reply) {
        reply.withUseCase(queryContext.getUseCase(UxAdminUseCaseName.Docs));
    }
}

